grid Cookbook
=============

This cookbook provides some attributes for distributed computing environment and some operarional commands.

Requirements
------------

Nothing.

Attributes
----------

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['grid']['etc_root']`|String|Configuration directory for grid.|`'/grid/etc'`|
|`['grid']['app_root']`|String|Application root directory for grid.|`'/grid/usr'`|
|`['grid']['vol_root']`|String|Data volume root directory for grid.|`'/grid/vol'`|
|`['grid']['max_vol_nums']`|String|Max data volumes|`'1'`|
|`['grid']['cacert']['path']`|String|Grid CA certificate file path.|`'/etc/ssl/certs/grid_internal_cacert.pem'`|
|`['grid']['cacert']['source']`|String|CA certificate source file path.|`'etc/ssl/certs/grid_internal_cacert.pem'`|
|`['grid']['gridctl']['env']['DOMAIN']`|String|e.g. `'grid.example.com'`|`''` (for localhost; pseudo distributed env.)|
|`['grid']['gridctl']['env']['HADOOP_ARTIFACT_TYPE']`|String|'package' or 'tarball'|`''`|
|`['grid']['gridctl']['env']['HADOOP_DISTRIBUTION']`|String|'apache'or 'cdh(3 or 4)'|`'hdp'`|
|`['grid']['gridctl']['env']['HADOOP_HOME']`|String|e.g. `'/grid/usr/hadoop'`|`''`|
|`['grid']['gridctl']['env']['HADOOP_PREFIX']`|String|e.g. `'$HADOOP_HOME'`|`''`|
|`['grid']['gridctl']['env']['HADOOP_CONF_DIR']`|String||`''`|
|`['grid']['gridctl']['env']['HDFS_USER']`|String||`'hdfs'`|
|`['grid']['gridctl']['env']['MAPRED_USER']`|String||`'mapred'`|
|`['grid']['gridctl']['env']['DN_INIT_USER']`|String||`'root'`|
|`['grid']['gridctl']['env']['NAMENODE']`|String|e.g. `'nn00'`|`'localhost'`|
|`['grid']['gridctl']['env']['SECONDARYNAMENODE']`|String|e.g. `'nn02'`|`'localhost'`|
|`['grid']['gridctl']['env']['DATANODES']`|String|e.g. `'dn00000 dn00001'`|`'localhost'`|
|`['grid']['gridctl']['env']['BALANCER']`|String||`'localhost'`|
|`['grid']['gridctl']['env']['JOBTRACKER']`|String|e.g. `'jt00'`|`'localhost'`|
|`['grid']['gridctl']['env']['TASKTRACKERS']`|String||`'$DATANODES'`|
|`['grid']['gridctl']['env']['HISTORYSERVER']`|String||`'localhost'`|
|`['grid']['gridctl']['env']['YARN_USER']`|String||`'yarn'`|
|`['grid']['gridctl']['env']['RESOURCEMANAGER']`|String|e.g. `'rm00'`|`'localhost'`|
|`['grid']['gridctl']['env']['NODEMANAGERS']`|String||`'$DATANODES'`|
|`['grid']['gridctl']['env']['HBASE_HOME']`|String|e.g. `'/grid/usr/hbase'`|`''`|
|`['grid']['gridctl']['env']['HBASE_USER']`|String||`'hbase'`|
|`['grid']['gridctl']['env']['HMASTERS']`|String|e.g. `'hm00 hm01'`|`'localhost'`|
|`['grid']['gridctl']['env']['HREGIONSERVERS']`|String|e.g. `'dn00000 dn00001'`|`'localhost'`|
|`['grid']['gridctl']['env']['ZOOKEEPER_PREFIX']`|String|e.g. `'/grid/usr/zookeeper'`|`''`|
|`['grid']['gridctl']['env']['ZOOCFGDIR']`|String||`'${ZOOKEEPER_PREFIX}/conf'`|
|`['grid']['gridctl']['env']['ZOOKEEPER_USER']`|String||`'zookeeper'`|
|`['grid']['gridctl']['env']['ZOOKEEPER_PEERS']`|String|e.g. `'zk00 zk01 zk02'`|`'localhost'`|

Usage
-----
#### grid::default
- creates fundamental derectories.

#### grid::ops-utils
- installs the following operational commands.
-- dsh_ipass
-- gridctl

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
