#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'rubygems'
# [chef-workstation]$ sudo /opt/chef/embedded/bin/gem install bracecomp
# String.expand()
require 'bracecomp'

module Grid
  REALM = 'GRID.EXAMPLE.COM'
  DOMAIN = 'grid.example.com'
  COLOCATION = 'colo00'
  CLUSTERS = {
    :base => {
      :admins => {
        :name => 'admins',
        :alias => 'AdministrativeStations',
        :use_host_object => 'generic-admin-host',
        :service_hostname => nil,
        :nodes => 'adm00'.expand,
        #:nodes => 'adm0{0..1}'.expand,
        :mcast_addr => '239.2.10.0'
      },
      :nameservices => {
        :name => 'nameservices',
        :alias => 'NameServices',
        :use_host_object => 'generic-nameservice-host',
        :service_hostname => nil,
        :nodes => 'ns00'.expand,
        #:nodes => 'ns0{0..1}'.expand,
        :mcast_addr => '239.2.10.1'
      },
      :nagioses => {
        :name => 'nagioses',
        :alias => 'Nagioses',
        :use_host_object => 'generic-nagios-host',
        :service_hostname => 'base-nm',
        :nodes => 'nm90'.expand,
        #:nodes => 'nm9{0..1}'.expand,
        :mcast_addr => '239.2.10.2'
      },
      :gmetads => {
        :name => 'gmetads',
        :alias => 'Ganglia',
        :use_host_object => 'generic-gmetad-host',
        :service_hostname => 'gm90',
        #:service_hostname => 'base-gm',
        :nodes => 'gm90'.expand,
        #:nodes => 'gm9{0..1}'.expand,
        :mcast_addr => '239.2.10.3'
      },
      :zookeepers => {
        :name => 'zookeepers',
        :alias => 'ZooKeepers',
        :use_host_object => 'generic-zookeeper-host',
        :service_hostname => nil,
        :nodes => 'zk0{0..2}'.expand,
        :mcast_addr => '239.2.10.4'
      },
      :provisioningmasters => {
        :name => 'provisioningmasters',
        :alias => 'ProvisioningMasters',
        :use_host_object => 'generic-provisioningmaster-host',
        :service_hostname => 'base-gpm',
        :nodes => 'gpm00'.expand,
        #:nodes => 'gpm0{0..1}'.expand,
        :mcast_addr => '239.2.10.5'
      }
    },
    :pleiades => {
      :nagioses => {
        :name => 'nagioses',
        :alias => 'Nagioses',
        :use_host_object => 'generic-nagios-host',
        :service_hostname => 'pleiades-nm',
        :nodes => 'nm00'.expand,
        #:nodes => 'nm0{0..1}'.expand,
        :mcast_addr => '239.2.11.2'
      },
      :gmetads => {
        :name => 'gmetads',
        :alias => 'Ganglia',
        :use_host_object => 'generic-gmetad-host',
        :service_hostname => 'gm00',
        #:service_hostname => 'pleiades-gm',
        :nodes => 'gm00'.expand,
        #:nodes => 'gm0{0..1}'.expand,
        :mcast_addr => '239.2.11.3'
      },
=begin
      :metas => {
        :name => 'metas',
        :alias => 'Metas',
        :use_host_object => 'generic-meta-host',
        :service_hostname => 'pleiades-meta',
        :nodes => 'meta00'.expand,
        #:nodes => 'meta0{0..1}'.expand,
        :mcast_addr => '239.2.11.4'
      },
=end
      :gateways => {
        :name => 'gateways',
        :alias => 'Gateways',
        :use_host_object => 'generic-gateway-host',
        :service_hostname => 'pleiades-gw',
        :nodes => 'gw00'.expand,
        #:nodes => 'gw0{0..1}'.expand,
        :mcast_addr => '239.2.11.5'
      },
      :workflows => {
        :name => 'workflows',
        :alias => 'Workflows',
        :use_host_object => 'generic-workflow-host',
        :service_hostname => 'pleiades-wf',
        :nodes => 'wf00'.expand,
        #:nodes => 'wf0{0..1}'.expand,
        :mcast_addr => '239.2.11.6'
      },
      :proxies => {
        :name => 'proxies',
        :alias => 'Proxies',
        :use_host_object => 'generic-proxy-host',
        :service_hostname => 'pleiades-pxy',
        :nodes => 'pxy00'.expand,
        #:nodes => 'pxy0{0..1}'.expand,
        :mcast_addr => '239.2.11.7'
      },
      :namenodes => {
        :name => 'namenodes',
        :alias => 'NameNodes',
        :use_host_object => 'generic-namenode-host',
        :service_hostname => 'pleiades-nn',
        :nodes => 'nn0{0,2}'.expand,
        #:nodes => 'nn0{0..2}'.expand,
        :mcast_addr => '239.2.11.8'
      },
=begin
      :resourcemanagers => {
        :name => 'resourcemanagers',
        :alias => 'ResourceManagers',
        :use_host_object => 'generic-resourcemanager-host',
        :service_hostname => 'pleiades-rm',
        :nodes => 'rm00'.expand,
        #:nodes => 'rm0{0..1}'.expand,
        :mcast_addr => '239.2.11.9'
      },
=end
      :jobtrackers => {
        :name => 'jobtrackers',
        :alias => 'JobTrackers',
        :use_host_object => 'generic-jobtracker-host',
        :service_hostname => 'pleiades-jt',
        :nodes =>  'jt00'.expand,
        #:nodes =>  'jt0{0..1}'.expand,
        :mcast_addr => '239.2.11.9'
      },
=begin
      :historyservers => {
        :name => 'historyservers',
        :alias => 'HistoryServers',
        :use_host_object => 'generic-historyserver-host',
        :service_hostname => 'pleiades-jh',
        :nodes => 'jh0{0..1}'.expand,
        :mcast_addr => '239.2.11.9'
      },
=end
      :hbasemasters => {
        :name => 'hbasemasters',
        :alias => 'HBaseMasters',
        :use_host_object => 'generic-hbasemaster-host',
        :service_hostname => nil,
        :nodes => 'hm0{0..1}'.expand,
        :mcast_addr => '239.2.11.10'
      },
      :datanodes => {
        :name => 'datanodes',
        :alias => 'DataNodes',
        :use_host_object => 'generic-datanode-host',
        :service_hostname => nil,
        :nodes => 'dn0000{0..1}'.expand,
        :mcast_addr => '239.2.11.20'
      }
    },
    :praesepe => {
      :gmetads => {
        :name => 'gmetads',
        :alias => 'Ganglia',
        :use_host_object => 'generic-gmetad-host',
        :service_hostname => 'gm10',
        #:service_hostname => 'ptolemy-gm',
        :nodes => 'gm10'.expand,
        #:nodes => 'gm1{0..1}'.expand,
        :mcast_addr => '239.2.12.3'
      },
      :namenodes => {
        :name => 'namenodes',
        :alias => 'NameNodes',
        :use_host_object => 'generic-namenode-host',
        :service_hostname => 'ptolemy-nn',
        :nodes => 'nn10'.expand,
        #:nodes => 'nn1{0..2}'.expand,
        :mcast_addr => '239.2.12.8'
      },
=begin
      :resourcemanagers => {
        :name => 'resourcemanagers',
        :alias => 'ResourceManagers',
        :use_host_object => 'generic-resourcemanager-host',
        :service_hostname => 'ptolemy-rm',
        :nodes => 'rm10'.expand,
        #:nodes => 'rm1{0..1}'.expand,
        :mcast_addr => '239.2.12.9'
      },
=end
      :jobtrackers => {
        :name => 'jobtrackers',
        :alias => 'JobTrackers',
        :use_host_object => 'generic-jobtracker-host',
        :service_hostname => 'ptolemy-jt',
        :nodes =>  'jt10'.expand,
        #:nodes =>  'jt1{0..1}'.expand,
        :mcast_addr => '239.2.12.9'
      },
=begin
      :historyservers => {
        :name => 'historyservers',
        :alias => 'HistoryServers',
        :use_host_object => 'generic-historyserver-host',
        :service_hostname => 'ptolemy-jh',
        :nodes => 'jh1{0..1}'.expand,
        :mcast_addr => '239.2.12.9'
      },
=end
      :datanodes => {
        :name => 'datanodes',
        :alias => 'DataNodes',
        :use_host_object => 'generic-datanode-host',
        :service_hostname => nil,
        :nodes => 'dn1000{0..1}'.expand,
        :mcast_addr => '239.2.12.20'
      }
    },
    :hyades => {
    },
    :ptolemy => {
      :gmetads => {
        :name => 'gmetads',
        :alias => 'Ganglia',
        :use_host_object => 'generic-gmetad-host',
        :service_hostname => 'gm40',
        #:service_hostname => 'ptolemy-gm',
        :nodes => 'gm40'.expand,
        #:nodes => 'gm4{0..1}'.expand,
        :mcast_addr => '239.2.14.3'
      },
      :namenodes => {
        :name => 'namenodes',
        :alias => 'NameNodes',
        :use_host_object => 'generic-namenode-host',
        :service_hostname => 'ptolemy-nn',
        :nodes => 'nn40'.expand,
        #:nodes => 'nn0{0..2}'.expand,
        :mcast_addr => '239.2.14.8'
      },
=begin
      :resourcemanagers => {
        :name => 'resourcemanagers',
        :alias => 'ResourceManagers',
        :use_host_object => 'generic-resourcemanager-host',
        :service_hostname => 'ptolemy-rm',
        :nodes => 'rm40'.expand,
        #:nodes => 'rm4{0..1}'.expand,
        :mcast_addr => '239.2.14.9'
      },
=end
      :jobtrackers => {
        :name => 'jobtrackers',
        :alias => 'JobTrackers',
        :use_host_object => 'generic-jobtracker-host',
        :service_hostname => 'ptolemy-jt',
        :nodes =>  'jt40'.expand,
        #:nodes =>  'jt4{0..1}'.expand,
        :mcast_addr => '239.2.14.9'
      },
=begin
      :historyservers => {
        :name => 'historyservers',
        :alias => 'HistoryServers',
        :use_host_object => 'generic-historyserver-host',
        :service_hostname => 'ptolemy-jh',
        :nodes => 'jh4{0..1}'.expand,
        :mcast_addr => '239.2.14.9'
      },
=end
      :datanodes => {
        :name => 'datanodes',
        :alias => 'DataNodes',
        :use_host_object => 'generic-datanode-host',
        :service_hostname => nil,
        :nodes => 'dn4000{0..1}'.expand,
        :mcast_addr => '239.2.14.20'
      }
    }
  }
end

