#
# Cookbook Name:: krb5
# Recipe:: client
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node[:platform_family]
  when 'debian'
    package 'krb5-user' do
      action :install
    end
  when 'rhel'
    package 'krb5-workstation' do
      action :install
    end
end

template '/etc/krb5.conf' do
  source 'etc/krb5.conf'
  owner 'root'
  group 'root'
  mode '0644'
end

