#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe:: http_proxy
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

include_recipe 'berkshelf-api-server::http_proxy'

begin
  res = resources(:template => "#{node[:nginx][:dir]}/sites-available/berks-api")
  res.cookbook 'berkshelf-api-server-ya'
end

if node[:berkshelf_api][:proxy].has_key?(:ssl_certificate_key_vault_item) then
    item_conf = node[:berkshelf_api][:proxy][:ssl_certificate_key_vault_item]

    pkg = 'chef-vault'
    resources(:chef_gem => pkg) rescue chef_gem pkg do
      compile_time true if respond_to?(:compile_time)
      action :install
    end

    require 'chef-vault'
    item = ChefVault::Item.load(item_conf[:vault], item_conf[:name])
    secret = item[item_conf[:key]]

    file node[:berkshelf_api][:proxy][:ssl_certificate_key] do
      content secret
      sensitive true
      owner 'root'
      group 'root'
      mode 0400
      notifies :reload, 'service[nginx]', :delayed
    end

end

