jenkins-grid Cookbook
=====================

This cookbook sets up a Jenkins service.

## Contents

- [Requirements](#requirements)
  - [platforms](#platforms)
  - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [jenkins-grid::default](#jenkins-griddefault)
    - [jenkins-grid::docker-compose](#jenkins-griddocker-compose)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- none.

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['jenkins-grid']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/jenkins"`|
|`['jenkins-grid']['docker-compose']['jenkins_home']['path']`|String|Path string or nil (unset).|`'/var/lib/jenkins_home'`|
|`['jenkins-grid']['docker-compose']['jenkins_home']['owner']`|String, Int|Owner user name or uid.|`1000`|
|`['jenkins-grid']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### jenkins-grid::default

This recipe does nothing.

#### jenkins-grid::docker-compose

This recipe generates a docker-compose.yml for the Jenkins CI service.

### Role Examples

- `roles/jenkins.rb`

```ruby
name 'jenkins'
description 'Jenkins'

run_list(
  'role[docker]',
  'recipe[jenkins-grid::docker-compose]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'jenkins-grid' => {
    'docker-compose' => {
      'config' => {
        # Version 2 docker-compose format
        'version' => '2',
        'services' => {
          'jenkins' => {
            'restart' => 'always',
            'image' => 'jenkins:2.19.4',
            'ports' => [
              '8080:8080',
              '50000:50000',
            ],
            #'environment' => {
            #},
            #'volumes' => [
            #  # set automatically, if the node['jenkins-grid']['docker-compose']['jenkins_home']['path'] is not nil.
            #  "#{node['jenkins-grid']['docker-compose']['jenkins_home']['path']}:/var/jenkins_home",
            #],
          },
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
