kata-containers Cookbook
===================

This cookbook installs Kata Containers.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [kata-containers::default](#kata-containersdefault)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms

- CentOS, RHEL >= 7
- Ubuntu >= 16.04

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['kata-containers']['repo']['update']`|Boolean|Repository update flag.|`false`|

## Usage

### Recipes

#### kata-containers::default

This recipe installs Kata Containers.

### Role Examples

- `roles/kata-containers.rb`

```ruby
name 'kata-containers'
description 'Kata Containers'

run_list(
  'recipe[kata-containers::default]',
  # with docker-grid cookbook
  'recipe[docker-grid::engine]',
)

override_attributes(
  # with docker-grid cookbook
  'docker-grid' => {
    'engine' => {
      'daemon_extra_options' => [
        '--add-runtime kata-runtime=/usr/bin/kata-runtime',
        '--default-runtime=kata-runtime',
      ].join(' '),
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2018, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
