#!/usr/bin/env bash

PATH=.:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:`dirname $0`

usage() {
  echo 'Usage: cli_setup.sh [-y] [-h]'
  echo 'This script sets up DC/OS client.'
  echo
  echo "Options:"
  echo "  -h: this help."
  echo "  -y: always yes."
  echo
}

ARGS="$@"
# Validation
while getopts 'yh' OPT; do
  case $OPT in
    'y' )
      always_yes=1
      ;;
    'h' )
      usage
      exit 0
      ;;
    '?' )
      usage
      exit 1
      ;;
  esac
done

shift $((OPTIND - 1))

echo 'DC/OS client will be installed.'
while true; do
  if [ "$always_yes" = 1 ]; then
    break
  fi
  echo -n 'Continue the install? [y/N]: '
  read answer
  case $answer in
    'y' | 'yes' )
      break
      ;;
    '' | 'n' | 'no' )
      echo 'Install was aborted by user.'
      exit 0
      ;;
    * )
      ;;
  esac
done

user=`whoami`
sudo='sudo'
if [ $user = 'root' ]; then
  sudo=''
fi

CMD="$sudo curl <%= node['dcos-grid']['dcos_cli_release_url'] %> -o /usr/local/bin/dcos &&
$sudo chmod +x /usr/local/bin/dcos && 
$sudo /usr/local/bin/dcos config set core.dcos_url https://<%= node['dcos-grid']['bootstrap']['config']['master_list'][0] %>"
echo "Command: $CMD"
eval $CMD

# old way
#mkdir -p dcos && cd dcos && 
#curl -O https://downloads.dcos.io/dcos-cli/install.sh && 
#bash ./install.sh . https://<%= node['dcos-grid']['bootstrap']['config']['master_list'][0] %> && 
#source ./bin/env-setup
