ssh_utils Cookbook
==================

This cookbook sets up OpenSSH Server.

Requirements
------------

#### packages
- none.

#### cookbooks
- `ssl_cert` - to deploy SSH-CA public key. 

Attributes
----------

#### ssh_utils::default

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['ssh_utils']['with_ssl_cert_cookbook']`|Boolean|works with `ssl_cert` cookbook.|`false`|
|`['ssh_utils']['ssl_cert']['ca_pubkey_name']`|String|deployed SSH-CA public key name from chef-fault.|`nil`|
|`['ssh_utils']['ssl_cert']['ssh_ca_krl_name']`|String|deployed SSH-CA KRL name from chef-vault. (0.2.0 or later)|`nil`|
|`['ssh_utils']['sshd_config']['extra_props']['<property_name>']`|String of Array|properties for sshd_config.|empty|

Usage
-----
#### ssh_utils::default
- do nothing.

#### ssh_utils::server
- set up OpenSSH server.
- If `node['ssh_utils']['with_ssl_cert_cookbook']` is true,
`node['ssh_utils']['sshd_config']['extra_props']['TrustedUserCAKeys']` is overridden
 by the file path based on `node['ssh_utils']['ssl_cert']['ca_pubkey_name']` attribute.
- If `node['ssh_utils']['with_ssl_cert_cookbook']` is true,
`node['ssh_utils']['sshd_config']['extra_props']['RevokedKeys']` is overridden
 by the file path based on `node['ssh_utils']['ssl_cert']'ssh_ca_krl_name']` attribute too.

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

