#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe Spec:: app_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'berkshelf-api-server-ya::http_proxy' do
  let(:chef_run) {
    ChefSpec::SoloRunner.new {|node|
      node.set[:berkshelf_api][:app_host] = '192.168.1.10'
      node.set[:berkshelf_api][:proxy][:ssl] = true
      node.set[:berkshelf_api][:proxy][:ssl_certificate] = '/path/to/server.crt'
      node.set[:berkshelf_api][:proxy][:ssl_certificate_key] = '/path/to/server.key'
    }.converge(described_recipe)
  }

  it 'changes bind address to 192.168.1.10 in /etc/nginx/sites-available/berks-api' do
    expect(chef_run).to \
      render_file('/etc/nginx/sites-available/berks-api').
        with_content(/^\s+server\s+192\.168\.1\.10:/)
  end

  it 'enables ssl in /etc/nginx/sites-available/berks-api' do
    expect(chef_run).to \
      render_file('/etc/nginx/sites-available/berks-api').
        with_content(/^\s+ssl\s+on;$/)
  end

  it 'adds ssl_certificate setting in /etc/nginx/sites-available/berks-api' do
    expect(chef_run).to \
      render_file('/etc/nginx/sites-available/berks-api').
        with_content(%r|^\s+ssl_certificate\s+/path/to/server\.crt;$|)
  end

  it 'adds ssl_certificate_key setting in /etc/nginx/sites-available/berks-api' do
    expect(chef_run).to \
      render_file('/etc/nginx/sites-available/berks-api').
        with_content(%r|^\s+ssl_certificate_key\s+/path/to/server\.key;$|)
  end

  let(:chef_run_ssl_off) {
    ChefSpec::SoloRunner.new {|node|
      node.set[:berkshelf_api][:proxy][:ssl] = false
    }.converge(described_recipe)
  }

  it 'disables ssl in /etc/nginx/sites-available/berks-api' do
    expect(chef_run_ssl_off).to_not \
      render_file('/etc/nginx/sites-available/berks-api').
        with_content(/^\s+ssl\s+on;$/)
  end
end

