cluster_name = 'dcos1'

name cluster_name
description "#{cluster_name} cluster"

run_list(
  'recipe[platform_utils::platform_update]',
)

#env_run_lists

default_attributes(
)

override_attributes(
  'platform_utils' => {
    'platform_update' => {
      'auto_update' => true,
    },
  },
  'docker-grid' => {
    'engine' => {
      #'version' => '1.12.6-0~ubuntu-xenial',
      # default: aufs
      # Note: on Docker in LXD with ZFS on Ubuntu 16.04
      #   - vfs:     OK
      #   - overlay: NG, 'overlay' is not supported over zfs.
      #   - aufs:    NG, Error starting daemon: error initializing graphd.
      #   - zfs:     NG, Error starting daemon: error initializing graphd.
      'storage-driver_on_centos' => 'overlay',
      'storage-driver_on_ubuntu' => 'overlay',
      #'userns-remap' => 'default',
    },
  },
  'dcos-grid' => {
    #'dcos_release_url' => 'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh',
    'dcos_release_url' => 'https://downloads.dcos.io/dcos/stable/dcos_generate_config.sh',
    # 1.8.6
    #'dcos_release_url' => 'https://downloads.dcos.io/dcos/stable/commit/cfccfbf84bbba30e695ae4887b65db44ff216b1d/dcos_generate_config.sh',
    # 1.7-open
    #'dcos_release_url' => 'https://downloads.dcos.io/dcos/EarlyAccess/commit/14509fe1e7899f439527fb39867194c7a425c771/dcos_generate_config.sh',
    'dcos_cli_release_url' => 'https://downloads.dcos.io/binaries/cli/linux/x86-64/dcos-1.8/dcos',
    'bootstrap' => {
      'ip' => '10.1.3.100',
      'port' => '8080',
      'config' => {
        'cluster_name' => cluster_name,
        'master_list' => [
          '10.1.3.101',
          '10.1.3.102',
          '10.1.3.103',
        ],
        'resolvers' => [
          '8.8.8.8',
          '8.8.4.4',
          #{
          #  'invalid_name' => 'dummy',
          #},
        ],
        'oauth_enabled' => 'false',
        'telemetry_enabled' => 'false',
        #'invalid_key' => 'dummy',
=begin
        'dcos_overlay_network' => {
          'vtep_subnet' => '44.128.0.0/20',
          'vtep_mac_oui' => '70:B3:D5:00:00:00',
          'overlays' => [
            {
              'name' => 'dcos',
              'subnet' => '9.0.0.0/8',
              'prefix' => '26',
            },
          ],
        },
=end
      },
      'ip-detect' => {
        # the first detected interface's ip is adopted.
        'interface' => 'eth1,eth0,enp0s8,enp0s3',
      },
    },
    'node' => {
      'auto_setup' => false,
    },
  },
)
