#
# Cookbook Name:: cdh
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['cdh']['version'] = '4.3.1'
default['cdh']['archive_url'] = 'http://archive.cloudera.com'  # or local mirror site.
default['cdh']['yum_repo']['with_gplextras'] = false  # LZO etc. CDH4 only.
default['cdh']['yum_repo']['update'] = false
default['cdh']['yum_repo']['only_for_mirroring'] = false
default['cdh']['yum_repo']['mirroring']['platform'] = 'centos'  # centos|rhel|suse
default['cdh']['yum_repo']['mirroring']['platform_version'] = '6'
default['cdh']['yum_repo']['mirroring']['arch'] = 'x86_64'  # i386|x86_64

default['cdh']['yum_mirror']['user'] = 'yum-mirror'
default['cdh']['yum_mirror']['cron_period'] = '#0 4   * * *'  # default: inactive
default['cdh']['yum_mirror']['base_path'] = '/var/spool/cdh-mirror'
default['cdh']['yum_mirror']['yum_conf'] = value_for_platform_family(
  'debian' => '/etc/yum/yum.conf',
  'rhel' => '/etc/yum.conf'
)
default['cdh']['yum_mirror']['repos_dir'] = value_for_platform_family(
  'debian' => '/etc/yum/repos.d',
  'rhel' => '/etc/yum.repos.d'
)
default['cdh']['yum_mirror']['repo_ids'] = []
default['cdh']['yum_mirror']['arch'] = 'x86_64'
default['cdh']['yum_mirror']['url_alias_with_authority_part'] = true
#default['cdh'][''] = 

