#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

name 'grid-ns-master'
description 'Grid nameservice master node'

run_list(
  'role[grid-ns]',
  'recipe[ssl_cert::default]',
  'recipe[krb5::admin]',
  'recipe[openldap::server]',
)

#env_run_lists()

default_attributes(
)

override_attributes(
  'ssl_cert' => {
    'ca_cert_file_prefix' => '00',
    'server_cert_file_prefix' => '01',
    'server_key_file_prefix' => '01',
    'ca_names' => [
      'grid_ca',
    ],
    'common_names' => [
      'ldap.grid.example.com',
    ],
  },
  'openldap' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_name' => 'grid_ca',
      'common_name' => 'ldap.grid.example.com',
    },
  },
)

