#!/usr/bin/env bash

PATH=.:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/bin:`dirname $0`

help() {
  echo 'Usage: node_setup.sh {master,agent,slave,agent_public,slave_public}'
}

ARGS="$@"
ROLE=$1

# Validation
if [ $# != 1 ]; then
  help
  exit 1
elif [ $ROLE = '-h' ]; then
  help
  exit 0
fi

case "$ROLE" in
  'master' | 'slave' | 'slave_public' )
    ;;
  # aliases
  'agent' | 'agent_public' )
    ROLE=${ROLE//agent/slave}
    ;;
  'public_agent' | 'public-agent' )
    ROLE='slave_public'
    ;;
  * )
    help
    exit 1
    ;;
esac
echo "Node Role: $ROLE"

if [ -d /opt/mesosphere ]; then
  echo -e '[ERROR] DC/OS is already installed.'
  exit 1
fi

user=`whoami`
sudo='sudo'
if [ $user = 'root' ]; then
  sudo=''
fi

if [ ! -d /tmp/dcos ]; then
  mkdir /tmp/dcos
fi
cd /tmp/dcos
echo 'Downloading dcos_install.sh ...'
curl -O <%= node['dcos-grid']['bootstrap']['config']['bootstrap_url'] %>/dcos_install.sh
echo "Installing DC/OS $ROLE node ..."
$sudo bash dcos_install.sh $ROLE

