#
# Cookbook Name:: concourse-ci
# Recipe:: fly
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

fly_ver = node['concourse-ci']['fly']['version']
release_checksum = node['concourse-ci']['fly']['release_checksum']
path_to_fly = node['concourse-ci']['fly']['install_path']

remote_file path_to_fly do
  source node['concourse-ci']['fly']['release_url']
  checksum release_checksum unless release_checksum.nil?
  owner 'root'
  group 'root'
  mode '0755'
  action :create
  not_if "#{path_to_fly} -v | grep #{fly_ver}"
  not_if { ::File.exist?(path_to_fly) } unless node['concourse-ci']['fly']['auto_upgrade']
end
