supermarket-omnibus-ya Cookbook
===============================

This is Yet Another `supermarket-omnibus-cookbook` cookbook.
This cookbook provides the following extra features to the original cookbook.

- SSL server key pair deployment by the Chef Vault.
- oc-id setup by the Chef Vault.

## Contents

- [Requirements](#requirements)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [supermarket-omnibus-ya::default](#supermarket-omnibus-yadefault)
    - [Role Examples](#role-examples)
    - [SSL server keys and certificates management by ssl_cert cookbook](#ssl-server-keys-and-certificates-management-by-ssl_cert-cookbook)
    - [oc-id app ID and secret management by Chef Vault](#oc-id-app-id-and-secret-management-by-chef-vault)
- [License and Authors](#license-and-authors)

## Requirements

### packages
- `supermarket-omnibus-cookbook` - the original cookbook.
- `ssl_cert`

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['supermarket-omnibus-ya']['with_ssl_cert_cookbook']`|Boolean|Deploy SSL server key pair by the `ssl_cert` cookbook.|`false`|
|`['supermarket-omnibus-ya']['ssl_cert']['common_name']`|String|Common name for TLS|`node['fqdn']`|
|`['supermarket-omnibus-ya']['chef_oauth2_app_id_vault_item']`|Hash|Chef Vault item configurations for oc-id app. id. See `attributes/default.rb`.|`{}`|
|`['supermarket-omnibus-ya']['chef_oauth2_secret_vault_item']`|Hash|Chef Vault item configurations for oc-id secret. See `attributes/default.rb`.|`{}`|

## Usage

### Recipes

#### supermarket-omnibus-ya::default

This recipe sets up a Chef Supermarket server.

### Role Examples

- `roles/supermarket.rb`

```ruby
name 'supermarket'
description 'Chef Supermarket'

run_list(
  'recipe[ssl_cert::server_key_pairs]',
  'recipe[supermarket-omnibus-ya::default]',
)

#env_run_lists()

#default_attributes()

cn = 'supermarket.io.example.com'
chef_cn = 'chef.io.example.com'

override_attributes(
  'ssl_cert' => {
    'common_names' => [
      cn,
    ],
  },
  'supermarket_omnibus' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => cn,
    },
    'config' => {
      'fqdn' => cn,
    },
    'chef_server_url' => "https://#{chef_cn}",
    'chef_oauth2_url' => "https://#{chef_cn}",
    'chef_oauth2_verify_ssl' => false,
    # Not recommended: instead use the `['supermarket_omnibus']['chef_oauth2_app_id_vault_item']` attribute.
    #'chef_oauth2_app_id' => '<supermarket_uid>',
    'chef_oauth2_app_id_vault_item' => {
      'vault' => 'supermarket',
      'name' => 'chef_oauth2_app_id',
      # single app_id or nested hash app_id path delimited by slash
      'env_context' => false,
      'key' => 'app_id',  # real hash path: "/app_id", Note: do not use `id`, which is preserved by Chef Vault.
      # or nested hash id path delimited by slash
      #'env_context' => true,
      #'key' => 'hash/path/to/app_id',  # real hash path: "/#{node.chef_environment}/hash/path/to/app_id"
    },
    # Not recommended: instead use the `['supermarket_omnibus']['chef_oauth2_secret_vault_item']` attribute.
    #'chef_oauth2_secret' => '<supermarket_secret>',
    'chef_oauth2_secret_vault_item' => {
      'vault' => 'supermarket',
      'name' => 'chef_oauth2_secret',
      # single secret or nested hash secret path delimited by slash
      'env_context' => false,
      'key' => 'secret',  # real hash path: "/secret"
      # or nested hash secret path delimited by slash
      #'env_context' => true,
      #'key' => 'hash/path/to/secret',  # real hash path: "/#{node.chef_environment}/hash/path/to/secret"
    },
  },
)
```

### SSL server keys and certificates management by ssl_cert cookbook

- create vault items.

```text
$ ruby -rjson -e 'puts JSON.generate({"private" => File.read("supermarket_io_example_com.prod.key")})' \
> > ~/tmp/supermarket_io_example_com.prod.key.json

$ ruby -rjson -e 'puts JSON.generate({"public" => File.read("supermarket_io_example_com.prod.crt")})' \
> > ~/tmp/supermarket_io_example_com.prod.crt.json

$ cd $CHEF_REPO_PATH

$ knife vault create ssl_server_keys supermarket.io.example.com.prod \
> --json ~/tmp/supermarket_io_example_com.prod.key.json

$ knife vault create ssl_server_certs supermarket.io.example.com.prod \
> --json ~/tmp/supermarket_io_example_com.prod.crt.json
```

- grant reference permission to the supermarket host

```text
$ knife vault update ssl_server_keys  supermarket.io.example.com.prod -S 'name:supermarket*.io.example.com'
$ knife vault update ssl_server_certs supermarket.io.example.com.prod -S 'name:supermarket*.io.example.com'
```

- modify run_list and attributes

```ruby
run_list(
  'recipe[ssl_cert::server_key_pairs]',
  'recipe[supermarket-omnibus-ya::default]',
)

override_attributes(
  'ssl_cert' => {
    'common_names' => [
      'supermarket.io.example.com',
    ],
  },
  'supermarket_omnibus' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => 'supermarket.io.example.com',
    },
    # ...
  },
)
```

### oc-id app ID and secret management by Chef Vault

- create vault items.

```text
$ cat ~/tmp/supermarket_chef_oauth2_app_id.json
{"app_id":"***************************************************************"}
$ cat ~/tmp/supermarket_chef_oauth2_secret.json
{"secret":"***************************************************************"}

$ knife vault create supermarket chef_oauth2_app_id --json ~/tmp/supermarket_chef_oauth2_app_id.json
$ knife vault create supermarket chef_oauth2_secret --json ~/tmp/supermarket_chef_oauth2_secret.json
```

- grant reference permission to the Supermarket host

```text
$ knife vault update supermarket chef_oauth2_app_id -S 'name:supermarket*.io.example.com'
$ knife vault update supermarket chef_oauth2_secret -S 'name:supermarket*.io.example.com'
```

- modify attributes

```ruby
override_attributes(
  'supermarket_omnibus' => {
    'chef_oauth2_app_id_vault_item' => {
      'vault' => 'supermarket',
      'name' => 'chef_oauth2_app_id',
      'env_context' => false,
      'key' => 'app_id',
    },
    'chef_oauth2_secret_vault_item' => {
      'vault' => 'supermarket',
      'name' => 'chef_oauth2_secret',
      'env_context' => false,
      'key' => 'secret',
    },
    # ...
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2016-2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
