#
# Cookbook Name:: bind-grid
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['bind-grid']['role'] = 'master'  # or 'slave'
default['bind-grid']['acl'] = {
  'internal' => [
    '127.0.0.1',
  ],
}
default['bind-grid']['extra_statements'] = ''
default['bind-grid']['options'] = {
  'directory' => '/var/cache/bind',
  'listen-on' => {
    'port' => '53',
    'ipaddresses' => [],
  },
  'listen-on-v6' => {
    'port' => '53',
    'ipaddresses' => [],  # 'any' or 'none' (default)
  },
  'dnssec-validation' => 'auto',
  'auth-nxdomain' => 'no',
  'allow-query' => [
    'internal',
  ],
  'recursion' => 'yes',
  'allow-recursion' => [
    'internal',
  ],
  'allow-transfer' => [],
  'forwarders' => [
    #'8.8.8.8',
    #'8.8.4.4',
  ],
  'extra_statements' => '',
}
# Option attributes for zone file templates added in wrapper cookbook.
default['bind-grid']['zone'] = {
  'files' => [
    #'db.192.168.1',
    #'db.example.com',
  ],
  'SOA' => {
    'MNAME' => '',  # 'dns.example.com'
    'RNAME' => '',  # 'root.example.com'
  },
  'NS' => [
    #'',  # 'dns.example.com'
  ],
  'masters' => [
    #'192.168.1.53',
  ],
  'allow-transfer' => [
    #'192.168.1.54',
  ],
}
