apt_utils Cookbook
==================

This cookbook includes apt utility (apt-cacher-ng, apt mirroring site setup and apt source configuration) recipes.

## Contents

- [Requirements](#requirements)
    - [packages](#packages)
- [Attributes](#attributes)
    - [apt_utils::default](#apt_utilsdefault)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [apt_utils::apt](#apt_utilsapt)
        - [apt_utils::aptly](#apt_utilsaptly)
        - [apt_utils::aptly-docker-compose](#apt_utilsaptly-docker-compose)
            - [SSL server keys and certificates management by the `ssl_cert` cookbook](#ssl-server-keys-and-certificates-management-by-the-ssl_cert-cookbook)
        - [apt_utils::conf](#apt_utilsconf)
        - [apt_utils::apt-cacher-ng](#apt_utilsapt-cacher-ng)
        - [apt_utils::mirror](#apt_utilsmirror)
        - [apt_utils::source](#apt_utilssource)
- [License and Authors](#license-and-authors)

## Requirements

### packages

- `apt`
- `docker-grid` >= 0.2.7
- `platform_utils` >= 0.4.3
- `ssl_cert` >= 0.3.7


## Attributes

### apt_utils::default

|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['apt_utils']['conf']['proxy']['sequence']`|String|Sequence number of apt proxy configuration file (ver. 0.1.1 or later)|`'80'`|
|`['apt_utils']['conf']['proxy']['ftp']`|String|Proxy setting for FTP (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['conf']['proxy']['http']`|String|Proxy setting for HTTP (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['conf']['proxy']['https']`|String|Proxy setting for HTTPS (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['aptly']['apt_repo']['keyserver']`|String||`'keys.gnupg.net'`|
|`['apt_utils']['aptly']['apt_repo']['recv-keys']`|String||`'9E3E53F19C7DE460'`|
|`['apt_utils']['aptly']['user']`|String||`'root'`|
|`['apt_utils']['aptly']['conf']`|Hash|`aptly.conf` configurations.|See `attributes/default.rb`|
|`['apt_utils']['aptly']['with_ssl_cert_cookbook']`|Boolean|Activates TLS configurations by the `ssl_cert` cookbook. See `attributes/default.rb`|`false`|
|`['apt_utils']['aptly']['ssl_cert']['common_name']`|String|Server common name for TLS|`node['fqdn']`|
|`['apt_utils']['aptly']['docker-compose']['app_dir']`|String|aptly app. root directory for docker-compose.|`"#{node['docker-grid']['compose']['app_dir']}/aptly"`|
|`['apt_utils']['aptly']['docker-compose']['etc_dir']`|String||`"#{node['apt_utils']['aptly']['docker-compose']['app_dir']}/etc"`|
|`['apt_utils']['aptly']['docker-compose']['data_dir']`|String|Persistent volume path or nil (unset).|`"#{node['apt_utils']['aptly']['docker-compose']['app_dir']}/data"`|
|`['apt_utils']['aptly']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|
|`['apt_utils']['apt-cacher-ng']['autopilot']['enabled']`|Boolean|APT Cacher NG autopilot feature flag.|`false`|
|`['apt_utils']['apt-cacher-ng']['autopilot']['log_dir']`|String|log file's directory path.|`'/var/log'`|
|`['apt_utils']['apt-cacher-ng']['autopilot']['wait_time']`|String|wait time after booted.|`'120s'`|
|`['apt_utils']['apt-cacher-ng']['autopilot']['check_period']`|String|service check period. `'#'` means inactive.|`'*/5 * * * *'`|
|`['apt_utils']['apt-cacher-ng']['CacheDir']`|String|path to cache directory|`'/var/cache/apt-cacher-ng'`|
|`['apt_utils']['apt-cacher-ng']['LogDir']`|String|path to log directory.|`'/var/log/apt-cacher-ng'`|
|`['apt_utils']['apt-cacher-ng']['Port']`|String|service port number.|`'3142'`|
|`['apt_utils']['apt-cacher-ng']['BindAddress']`|String|service bind address|`''` (0.0.0.0)|
|`['apt_utils']['apt-cacher-ng']['UseWrap']`|String|with TCP Wrappers (ver. 0.1.2 or later)|`nil` (`'0'`(default) or `'1'` (on))|
|`['apt_utils']['mirror']['user']`|String|service user.|`'apt-mirror'`|
|`['apt_utils']['mirror']['cron_period']`|String|cron period expression.|`'#0 4   * * *'` (inactive)|
|`['apt_utils']['mirror']['base_path']`|String|mirroring base path.|`'/var/spool/apt-mirror'`|
|`['apt_utils']['mirror']['nthreads']`|String|worker threads number.|`'20'`|
|`['apt_utils']['mirror']['_tilde']`|||`'0'`|
|`['apt_utils']['mirror']['country']`|String|mirroring source country.|`'us'`|
|`['apt_utils']['mirror']['distributions']['debian']`|Hash|Debian's mirroring apt lines.|refer to `attributes/default.rb`|
|`['apt_utils']['mirror']['distributions']['ubuntu']`|Hash|Ubuntu's mirroring apt lines.|refer to `attributes/default.rb`|
|`['apt_utils']['source']['apt_lines']['ubuntu']`|Array|apt source lines.|refer to `attributes/default.rb`|

## Usage

### Recipes

#### apt_utils::apt

- includes `apt::default` recipe if the platform family is `debian`. 

#### apt_utils::aptly

This recipe installs `aptly` package.

- `roles/aptly.rb`: role example.

```ruby
name 'aptly'
description 'aptly'

run_list(
  'recipe[apt_utils::aptly]',
)
```

#### apt_utils::aptly-docker-compose

This recipe generates a `docker-compose.yml` file for the aptly service.

- `roles/aptly-docker-compose.rb`: role example.

```ruby
name 'aptly-docker-compose'
description 'aptly by docker-compose'

run_list(
  # see https://osdn.net/projects/metasearch/scm/git/grid-chef-repo/blobs/master/roles/docker-new-repo.rb
  'role[docker]',
  'recipe[apt_utils::aptly-docker-compose]',
)

aptly_port = '8080'
aptly_api_port = '8081'

override_attributes(
  'apt_utils' => {
    'aptly' => {
      'docker-compose' => {
        'config' => {
          'version' => '2',
          'services' => {
            'reverseproxy' => {
              'ports' => [
                "#{aptly_port}:8080",
                "#{aptly_api_port}:8081",
              ],
              'volumes' => [
                # This volume will be set by the apt_utils::aptly-docker-compose recipe automatically.
                #"#{node['apt_utils']['aptly']['docker-compose']['etc_dir']}/nginx/nginx.conf:/etc/nginx/nginx.conf:ro"
              ],
            },
            'aptly' => {
              'restart' => 'always',
              'image' => 'whitestar/aptly',
              'volumes' => [
                # This volume will be set by the apt_utils::aptly-docker-compose recipe automatically.
                #"#{node['apt_utils']['aptly']['docker-compose']['data_dir']}:/aptly-data:rw",
              ],
              'environment' => {
              },
            },
          },
        },
      },
    },
  },
)
```

- `roles/aptly-with-ssl-docker-compose.rb`: SSL setup role example.

```ruby
name 'aptly-with-ssl-docker-compose'
description 'aptly with SSL by docker-compose'

run_list(
  #'recipe[ssl_cert::server_key_pairs]',  # apt_utils cookbook < 0.2.4
  'role[docker]',
  'recipe[apt_utils::aptly-docker-compose]',
)

aptly_port = '8080'
aptly_api_port = '8081'
cn = 'aptly.io.example.com'

override_attributes(
  'ssl_cert' => {
    #'common_names' => [
    #  cn,  # apt_utils cookbook <= 0.2.6
    #],
  },
  'apt_utils' => {
    'aptly' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => cn,
      },
      'docker-compose' => {
        'config' => {
          'version' => '2',
          'services' => {
            'reverseproxy' => {
              'ports' => [
                "#{aptly_port}:8080",
                "#{aptly_api_port}:8081",
              ],
              'volumes' => [
                # These volumes will be set by the apt_utils::aptly-docker-compose recipe automatically.
                #"#{node['apt_utils']['aptly']['docker-compose']['etc_dir']}/nginx/nginx.conf:/etc/nginx/nginx.conf:ro"
                # and server key pair volume conf.
              ],
            },
            'aptly' => {
              'restart' => 'always',
              'image' => 'whitestar/aptly',
              'volumes' => [
                # This volume will be set by the apt_utils::aptly-docker-compose recipe automatically.
                #"#{node['apt_utils']['aptly']['docker-compose']['data_dir']}:/aptly-data:rw",
              ],
              'environment' => {
              },
            },
          },
        },
      },
    },
  },
)
```

##### SSL server keys and certificates management by the `ssl_cert` cookbook

- create vault items.

```text
$ ruby -rjson -e 'puts JSON.generate({"private" => File.read("aptly.io.example.com.prod.key")})' \
> > ~/tmp/aptly.io.example.com.prod.key.json

$ ruby -rjson -e 'puts JSON.generate({"public" => File.read("aptly.io.example.com.prod.crt")})' \
> > ~/tmp/aptly.io.example.com.prod.crt.json

$ cd $CHEF_REPO_PATH

$ knife vault create ssl_server_keys aptly.io.example.com.prod \
> --json ~/tmp/aptly.io.example.com.prod.key.json

$ knife vault create ssl_server_certs aptly.io.example.com.prod \
> --json ~/tmp/aptly.io.example.com.prod.crt.json
```

- grant reference permission to the Concourse host

```text
$ knife vault update ssl_server_keys  aptly.io.example.com.prod -S 'name:aptly-host.example.com'
$ knife vault update ssl_server_certs aptly.io.example.com.prod -S 'name:aptly-host.example.com'
```

- modify run_list and attributes

```ruby
run_list(
  #'recipe[ssl_cert::server_key_pairs]',  # apt_utils cookbook < 0.2.4
  'recipe[apt_utils::aptly-docker-compose]',
)

override_attributes(
  'ssl_cert' => {
    #'common_names' => [
    #  'aptly.io.example.com',  # apt_utils cookbook < 0.2.6
    #],
  },
  'aptly-grid' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'common_name' => 'nexus.io.example.com',
    },
    # ...
  },
)
```

#### apt_utils::conf

- deploys apt configuration files to the `/etc/apt/apt.conf.d` directory.

#### apt_utils::apt-cacher-ng

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::apt-cacher-ng]"
  ]
}
```

#### apt_utils::mirror

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::mirror]"
  ]
}
```

#### apt_utils::source

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::source]"
  ]
}
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2013-2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
