#!/bin/sh
set -e

backup_dir=./bak
backup_tmp_dir=${backup_dir}.tmp
workdir=<%= @workdir %>

echo 'Configurations backup started.'
sudo rm -rf ${backup_tmp_dir}
sudo mkdir -p ${backup_tmp_dir}

container_id=`sudo docker-compose ps -q bubbleupnp-server`
sudo docker cp ${container_id}:${workdir}/configuration.xml ${backup_tmp_dir}
sudo docker cp ${container_id}:${workdir}/cache ${backup_tmp_dir}
sudo docker cp ${container_id}:${workdir}/Playlists ${backup_tmp_dir}

if cat ${backup_tmp_dir}/configuration.xml | grep '<firstRun>' | grep false > /dev/null 2>&1; then
  sudo rm -rf $backup_dir
  sudo mv $backup_tmp_dir $backup_dir
fi
echo 'Configurations backup done.'
