#!/bin/bash
set -e

backup_dir=./bak
workdir=<%= @workdir %>

echo 'Configurations restore started.'
container_id=`sudo docker-compose ps -q bubbleupnp-server`
# Note: `docker cp` chown root:root
sudo docker cp ${backup_dir}/configuration.xml ${container_id}:${workdir}/
sudo docker cp ${backup_dir}/cache ${container_id}:${workdir}/
sudo docker cp ${backup_dir}/Playlists ${container_id}:${workdir}/

# fix file owner
sudo docker exec -u root ${container_id} chown -R bubbleupnpserver:users ${workdir}/{configuration.xml,cache,Playlists}
echo 'Configurations restore done.'