#
# Cookbook Name:: lxcs
# Recipe:: lxc
#
# Copyright 2017-2021, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

lxc_conf = node['lxcs']['lxc']

[
  'curl',
  'lxc',
  'lxc-templates',
  # Note: Ubuntu 20.04 LTS does not support yum package.
  #'yum'  # CentOS on lxc
].each {|pkg|
  resources(package: pkg) rescue package pkg do
    action :install
  end
}

service 'lxc-net' do
  action [:enable]
  supports status: true, restart: true, reload: false
end

predefined_env_vars = [
  'LXC_AUTO',
  'BOOTGROUPS',
  'SHUTDOWNDELAY',
  'OPTIONS',
  'STOPOPTS',
  'USE_LXC_BRIDGE',
  'USE_LXC_BRIDGE',
  'LXC_BRIDGE',
  'LXC_ADDR',
  'LXC_NETMASK',
  'LXC_NETWORK',
  'LXC_DHCP_RANGE',
  'LXC_DHCP_MAX',
]

[
  'lxc',
  'lxc-net',
].each {|conf|
  template "/etc/default/#{conf}" do
    source  "etc/default/#{conf}"
    owner 'root'
    group 'root'
    mode '0644'
    variables(
      predefined_env_vars: predefined_env_vars
    )
    notifies :restart, 'service[lxc-net]'
  end
}

if lxc_conf['unprivileged_container']['enabled']
  directory '/var/lib/lxc' do
    owner 'root'
    group 'root'
    mode '0711'
  end

  ::Chef::Recipe.send(:include, PlatformUtils::Helper)
  append_subusers(lxc_conf['unprivileged_container']['users_allow'])
end

[
  'default.conf',
  'lxc-usernet',
].each {|conf|
  template "/etc/lxc/#{conf}" do
    source  "etc/lxc/#{conf}"
    owner 'root'
    group 'root'
    mode '0644'
  end
}

lxc_conf['extra-default.conf'].each {|file_name, conf|
  template "/etc/lxc/#{file_name}" do
    source  'etc/lxc/extra-default.conf'
    owner 'root'
    group 'root'
    mode '0644'
    variables(
      conf: conf
    )
  end
}
