#
# Cookbook Name:: samba-grid
# Recipe:: server
#
# Copyright 2016-2021, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

platform = node['platform']
platform_version = node['platform_version']

%w(
  samba
  smbclient
  samba-vfs-modules
).each {|pkg|
  package pkg do
    action :install
  end
}

grp_conf = node['samba-grid']['group']['sambashare']
group 'sambashare' do
  action :modify
  gid grp_conf['gid'] if !grp_conf['gid'].nil? && !grp_conf['gid'].empty?
  members grp_conf['members'] if !grp_conf['members'].nil? && !grp_conf['members'].empty?
  append true
  only_if { !grp_conf['gid'].nil? && !grp_conf['gid'].empty? }
  only_if { !grp_conf['members'].nil? && !grp_conf['members'].empty? }
end

services = [
  'nmbd',
  'smbd',
]
services.push('samba-ad-dc') if platform == 'debian' && platform_version < '9.0'
# Note: systemd services by default
# 'samba-ad-dc',  # masked on latest Ubuntu.
# 'samba',        # masked on latest Debian and Ubuntu.

services.each {|srv|
  service srv do
    action [:enable]
    supports status: true, restart: true, reload: false
  end
}

# If you define same parameter repeatedly in the smb.conf,
# the last defined parameter's value is active.
template '/etc/samba/smb.conf' do
  source 'etc/samba/smb.conf'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :restart, 'service[nmbd]'
  notifies :restart, 'service[smbd]'
  notifies :restart, 'service[samba-ad-dc]' if platform == 'debian' && platform_version < '9.0'
  #notifies :reload, 'service[samba]'
end

# autopilot
srv = 'samba'
template "/etc/cron.d/#{srv}-local" do
  source  "etc/cron.d/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0644'
  action :delete unless node['samba-grid']['autopilot']['enabled']
end
