#
# Cookbook Name:: squid-proxy
# Recipe:: default
#
# Copyright 2017-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

pkgs = [
  'squid',
]
pkgs.push('squid-cgi') if node['squid-proxy']['with_cgi']

pkgs.each {|pkg|
  package pkg do
    action :install
  end
}

service 'squid' do
  action :enable
end

node['squid-proxy']['conf']['extra_confs'].each {|line|
  skip unless line.start_with?('cache_dir')
  cache_dir = line.split(' ')[2]
  directory cache_dir do
    owner 'proxy'
    group 'proxy'
    mode '0755'
    recursive true
    action :create
  end
}

template '/etc/squid/squid.conf' do
  source  'etc/squid/squid.conf'
  owner 'root'
  group 'root'
  mode '0644'
  action :create
  notifies :reload, 'service[squid]'
end

# autopilot
srv = 'squid'
template "/etc/cron.d/#{srv}-local" do
  source  "etc/cron.d/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0644'
  action :delete unless node['squid-proxy']['autopilot']['enabled']
end
