#
# Copyright 2016-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'docker4latest_ubuntu'
description '*DEPRECATED* Docker for the latest Ubuntu'

run_list(
  'role[docker]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'docker-grid' => {
    'install_flavor' => 'dockerproject',
    'dockerproject' => {
      'enable_new_repo' => true,
      'package_name' => 'docker-ce',  # new package name.
    },
    # install the package for the newer distribution of ubuntu.
    'apt_repo' => {
      # new repo.
      # Check https://download.docker.com/linux/ubuntu/dists
      'override_apt_line' => 'deb [arch=amd64] https://download.docker.com/linux/ubuntu bionic stable',
      #'override_apt_line' => 'deb [arch=amd64] https://download.docker.com/linux/ubuntu artful stable',
      # old repo.
      #'override_apt_line' => 'deb https://apt.dockerproject.org/repo ubuntu-zesty main',
      #'override_apt_line' => 'deb https://apt.dockerproject.org/repo ubuntu-xenial main',
    },
    'compose' => {
      #'skip_setup' => true,  # default: false
      'auto_upgrade' => true,  # default: false
      # Check https://github.com/docker/compose/releases
      'release_base_url' => 'https://github.com/docker/compose/releases/download/1.18.0',
      #'release_base_url' => 'https://github.com/docker/compose/releases/download/1.17.1',
    },
    'engine' => {
      # new package: `docker-ce``
      'version' => '17.12.1~ce-0~ubuntu',
      #'version' => '17.09.0~ce-0~ubuntu',
      #'version' => '17.06.2~ce-0~ubuntu',
      # old package: `docker-engine``
      #'version' => '17.05.0~ce-0~ubuntu-zesty',
      #'version' => '17.03.1~ce-0~ubuntu-yakkety',
      #'version' => '1.12.3-0~xenial',
      'storage-driver_on_ubuntu' => 'overlay2',  # default: aufs
      #'daemon_extra_options' => [
        #'-H fd:// --bip=192.168.100.1/24 --fixed-cidr=192.168.100.0/24',
        # for docker >= 1.10, docker-engine >= 1.12 (on rhel family)
        # '-H fd://' option automatically removed by this cookbook.
        # See https://github.com/docker/docker/issues/22847
      #].join(' '), 
      #'users_allow' => [
      #],
    },
  },
)
