#
# Cookbook Name:: ganglia
# Recipe:: web
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

httpd_service = nil
case node[:platform_family]
  when 'debian'
    %w{apache2 ganglia-webfrontend php5-gd}.each {|pkg|
      package pkg do
        action :install
      end
    }

    link '/etc/apache2/conf.d/ganglia-webfrontend.conf' do
      to '/etc/ganglia-webfrontend/apache.conf'
      action [:create]
    end

    httpd_service = 'apache2'
    resources(:service => httpd_service) rescue service httpd_service do
      action [:enable]
      supports :status => true, :restart => true, :reload => true
    end

    if node['ganglia']['web']['AuthType'] == 'Kerberos' then
      pkg = 'libapache2-mod-auth-kerb'
      resources(:package => pkg) rescue package pkg do
        action :install
      end
    end

    template '/etc/ganglia-webfrontend/apache.conf' do
      source 'etc/ganglia-webfrontend/apache.conf'
      owner 'root'
      group 'root'
      mode '0644'
      notifies :restart, "service[#{httpd_service}]"
    end
  when 'rhel'
    package 'ganglia-web' do
      action :install
    end

    httpd_service = 'httpd'
    resources(:service => httpd_service) rescue service httpd_service do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => true
    end

    if node['ganglia']['web']['AuthType'] == 'Kerberos' then
      resources(:package => 'mod_auth_kerb') rescue package 'mod_auth_kerb' do
        action :install
      end
    end

    template '/etc/httpd/conf.d/ganglia.conf' do
      source 'etc/httpd/conf.d/ganglia.conf'
      owner 'root'
      group 'root'
      mode '0644'
      notifies :restart, "service[#{httpd_service}]"
    end
end

