require 'rubygems'
require 'bracecomp'

name 'grid-gm'
description 'Grid Base ganglia gmetad node'

run_list(
  'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[ganglia-gmetad]',
  'role[ganglia-web]'
)

this_domain = 'grid.example.com'
mcast_addr = '239.2.10.3'
port = '8649'
polling_interval = 30

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'ganglia' => {
    'web' => {
      'Allow' => [
        "from .#{this_domain}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'GRID.EXAMPLE.COM',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'Ganglia',
      'owner' => this_domain
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
    },
    # gmetad
    'gridname' => 'Grid-Base',
    'trusted_hosts' => ['127.0.0.1'] + "nm9{0..1}.#{this_domain}".expand,
    'data_sources' => [
      {
        :name => 'AdministrativeStation',
        :polling_interval => polling_interval,
        :address_list => "adm0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'ProvisioningMaster',
        :polling_interval => polling_interval,
        :address_list => "gpm0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'NameService',
        :polling_interval => polling_interval,
        :address_list => "ns0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'ZooKeeper',
        :polling_interval => polling_interval,
        :address_list => "zk0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Nagios',
        :polling_interval => polling_interval,
        :address_list => "nm9{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Ganglia',
        :polling_interval => polling_interval,
        :address_list => "gm9{0..1}.#{this_domain}".expand
      },
    ]
  }
)
