#
# Cookbook Name:: nagios
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['nagios']['cluster_name'] = 'localhost'
# default: white list
default['nagios']['web']['Order'] = 'Deny,Allow'
default['nagios']['web']['Deny'] = ['from all']
default['nagios']['web']['Allow'] = [
  'from 127.0.0.1',
  'from ::1'
]
# AuthType: ''|'Basic'|'Kerberos'
default['nagios']['web']['AuthType'] = 'Basic'
## if AuthType == Basic
### Debian
default['nagios']['web']['mod_auth_basic']['AuthUserFile'] = node.value_for_platform_family(
  'debian' => '/etc/nagios3/htpasswd.users',
  'rhel'   => '/etc/nagios/passwd'
)
## if AuthType == Kerberos
default['nagios']['web']['mod_auth_kerb']['KrbAuthRealms'] = 'LOCALDOMAIN'
default['nagios']['web']['mod_auth_kerb']['KrbServiceName'] = 'HTTP'
default['nagios']['web']['mod_auth_kerb']['Krb5Keytab'] = '/etc/krb5.keytab'
default['nagios']['web']['mod_auth_kerb']['KrbMethodNegotiate'] = 'on'
default['nagios']['web']['mod_auth_kerb']['KrbMethodK5Passwd'] = 'off'
# cgi.cfg
default['nagios']['authorized_for_system_information'] = 'nagiosadmin'
default['nagios']['authorized_for_configuration_information'] = 'nagiosadmin'
default['nagios']['authorized_for_system_commands'] = 'nagiosadmin'
default['nagios']['authorized_for_all_services'] = 'nagiosadmin'
default['nagios']['authorized_for_all_hosts'] = 'nagiosadmin'
default['nagios']['authorized_for_all_service_commands'] = 'nagiosadmin'
default['nagios']['authorized_for_all_host_commands'] = 'nagiosadmin'
# check_ganglia_metric
default['nagios']['check_ganglia_metric']['enabled'] = false
default['nagios']['check_ganglia_metric']['gmetad_host'] = 'localhost'
#default['nagios']['']

