name 'ldap-client-grid'
description 'LDAP client role for Grid'

run_list(
  'recipe[grid::cacert_deploy]',
  'role[ldap-client]',
  'recipe[openldap::nss-ldapd]'
)

uri = 'ldap://ldap.grid.example.com/'
base = 'dc=grid,dc=example,dc=com'
ca_cert_file = '/etc/ssl/certs/grid_internal_cacert.pem'

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'grid' => {
    'cacert' => {
      'path' => ca_cert_file
    }
  },
  'openldap' => {
    'client' => {
      'URI' => uri,
      'BASE' => base,
      'TLS_CACERT' => ca_cert_file,
      'TLS_REQCERT' => 'allow',
      'TLS_CHECKPEER' => 'yes',
      'SASL_MECH' => 'GSSAPI'
    },
    'nss-ldapd' => {
      'uri' => uri,
      'base' => base,
      'ssl' => 'start_tls',
      'tls_cacertfile' => ca_cert_file,
      'tls_reqcert' => 'demand'
    },
    'ldap_lookup_nameservices' => ['passwd', 'group']
  }
)

#override_attributes "apache2" => { "max_children" => "50" }
