name 'pleiades-gw'
description 'Pleiades gateway node'

run_list(
  'role[grid-realm]',
  'role[ganglia-gmond]',
  'role[pleiades-node]',
  'role[pig]'
)

mcast_addr = '239.2.11.5'
port = '8649'

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'Gateway',
      'owner' => 'grid.example.com'
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => [
        {
          'mcast_join' => '',
          'host' => "gw00.#{this.domain}",
          'port' => port,
          'ttl' => ''
        },
        {
          'mcast_join' => '',
          'host' => "gw01.#{this.domain}",
          'port' => port,
          'ttl' => ''
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  },
  'pig' => {
    'version' => '0.11.1'
  }
)
