/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * Swingを用いてGUIを実装したパッケージ
 */
package net.wasamon.mics.gui.swing;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JScrollPane;

import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.gui.MicsArchitectureViewer;

public class SwingArchitectureViewer extends MicsArchitectureViewer{

	private JFrame frame;

	private SwingArchitectureCanvas canvas;

	private JScrollPane pane;
	
	public SwingArchitectureViewer(MicsCompositeElement composite) {
		super(composite);
		if (composite.id() != null && !composite.id().equals("")) {
			frame = new JFrame("Architecture Viewer: " + composite.id());
		} else {
			frame = new JFrame("Architecture Viewer");
		}
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				frame.setVisible(false);
			}
		});
		frame.setBounds(10, 10, 600, 400);

		// frame.getContentPane().add(getToolBar(), BorderLayout.NORTH);
		canvas = new SwingArchitectureCanvas(this);
		pane = new JScrollPane(canvas, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		frame.add(pane, BorderLayout.CENTER);
		this.selectedElement = null;
		canvas.imageTable.clear();
	}
		
	private MicsElement selectedElement;

	public void setSelectedElement(MicsElement element) {
		if (element != null && selectedElement != element) {
			System.out.println(element.getInfo());
			this.selectedElement = element;
		}
	}

	public void show() {
		this.selectedElement = null;
		frame.setVisible(true);
		canvas.repaint();
	}

	public ViwerCanvas canvas() {
		return canvas;
	}
}
