/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * 新たなMICSシミュレーション要素を作成する際のユーティリティクラスのパッケージ
 */
package net.wasamon.mics.util;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * MICSシミュレーションでテーブル表示をする時の二列のテーブルモデル
 * @author Takefumi MIYOSHI
 *
 */
public class MicsTableModel implements TableModel {

	private String[] columns;

	private Object[][] data;

	public MicsTableModel(String[] col, Object[][] data) {
		this.columns = col;
		this.data = data;
	}

	public void addTableModelListener(TableModelListener l) {

	}

	public Class getColumnClass(int columnIndex) {
		return data[columnIndex][0].getClass();
	}

	public int getColumnCount() {
		return columns.length;
	}

	public String getColumnName(int columnIndex) {
		return columns[columnIndex];
	}

	public int getRowCount() {
		if (data != null) {
			return data[0].length;
		} else {
			return 0;
		}
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		return data[columnIndex][rowIndex];
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	public void removeTableModelListener(TableModelListener l) {
	}

	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		data[columnIndex][rowIndex] = aValue;
	}
}
