/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import java.util.Vector;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

abstract class AbstractVirtualMidiDevice
implements VirtualMidiDevice {
    protected boolean is_open = false;
    protected long top_microsecond = -1L;
    protected MidiDevice.Info info;
    private int max_transmitters = -1;
    protected List<Transmitter> transmitters = new Vector<Transmitter>();
    protected MidiChannelMessageSender[] channels = new MidiChannelMessageSender[16];
    private int max_receivers = 1;
    protected List<Receiver> receivers = new Vector<Receiver>();

    protected AbstractVirtualMidiDevice() {
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new MidiChannelMessageSender(this, i);
        }
    }

    protected void setMaxReceivers(int n) {
        this.max_receivers = n;
    }

    protected void setMaxTransmitters(int n) {
        this.max_transmitters = n;
    }

    @Override
    public void open() {
        this.is_open = true;
        this.top_microsecond = System.nanoTime() / 1000L;
    }

    @Override
    public void close() {
        this.transmitters.clear();
        this.is_open = false;
    }

    @Override
    public boolean isOpen() {
        return this.is_open;
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    @Override
    public long getMicrosecondPosition() {
        return this.top_microsecond == -1L ? -1L : System.nanoTime() / 1000L - this.top_microsecond;
    }

    @Override
    public int getMaxReceivers() {
        return this.max_receivers;
    }

    @Override
    public Receiver getReceiver() {
        return this.receivers.isEmpty() ? null : this.receivers.get(0);
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public int getMaxTransmitters() {
        return this.max_transmitters;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (this.max_transmitters == 0) {
            throw new MidiUnavailableException();
        }
        Transmitter transmitter = new Transmitter(){
            private Receiver rx = null;

            @Override
            public void close() {
                AbstractVirtualMidiDevice.this.transmitters.remove(this);
            }

            @Override
            public Receiver getReceiver() {
                return this.rx;
            }

            @Override
            public void setReceiver(Receiver receiver) {
                this.rx = receiver;
            }
        };
        this.transmitters.add(transmitter);
        return transmitter;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.transmitters;
    }

    @Override
    public MidiChannel[] getChannels() {
        return this.channels;
    }

    @Override
    public void sendMidiMessage(MidiMessage midiMessage) {
        long l = this.getMicrosecondPosition();
        for (Transmitter transmitter : this.transmitters) {
            Receiver receiver = transmitter.getReceiver();
            if (receiver == null) continue;
            receiver.send(midiMessage, l);
        }
    }

    @Override
    public void setReceiver(Receiver receiver) {
        if (this.max_receivers == 0) {
            return;
        }
        if (!this.receivers.isEmpty()) {
            this.receivers.clear();
        }
        this.receivers.add(receiver);
    }
}

