/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import javax.swing.JTextField;

class ChordTextField
extends JTextField {
    Music.Chord current_chord = null;
    long lyric_arrived_time = System.nanoTime();
    UnicodeConverter unicode_converter = new UnicodeConverter();

    public ChordTextField() {
        super(80);
        this.setMaximumSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public void appendChord(Music.Chord chord) {
        if (this.current_chord == null && chord == null) {
            return;
        }
        if (this.current_chord != null && chord != null && chord.equals(this.current_chord)) {
            return;
        }
        String string = "";
        this.setText(this.getText() + (chord == null ? string : chord + " "));
        this.current_chord = chord == null ? null : chord.clone();
    }

    public void addLyric(byte[] byArray) {
        byte[] byArray2;
        long l = System.nanoTime();
        String string = this.unicode_converter.convertToUnicode(byArray).trim();
        try {
            byArray2 = string.getBytes("MS932");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        String string2 = this.getText();
        if (l - this.lyric_arrived_time > 1000000000L && (byArray2.length > 8 || byArray2.length == 0 || string2 == null || string2.length() == 0)) {
            this.setText(string);
        } else {
            this.setText(string2 + " " + string);
        }
        this.setCaretPosition(this.getText().length());
        this.lyric_arrived_time = l;
    }
}

