/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DurationForm
extends JPanel
implements ActionListener,
ChangeListener {
    DurationModel model = new DurationModel();
    JSpinner spinner;
    NoteComboBox note_combo;
    JLabel title_label;
    JLabel unit_label;
    private int ppq = 960;

    public DurationForm() {
        this.model.addChangeListener(this);
        this.note_combo = new NoteComboBox();
        this.note_combo.addActionListener(this);
        this.title_label = new JLabel("Duration:");
        this.add(this.title_label);
        this.add(this.note_combo);
        this.spinner = new JSpinner(this.model);
        this.add(this.spinner);
        this.unit_label = new JLabel("[Ticks]");
        this.add(this.unit_label);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.note_combo.getDuration();
        if (n < 0) {
            return;
        }
        this.model.setDuration(n);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.note_combo.setDuration(this.model.getDuration());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.title_label.setEnabled(bl);
        this.spinner.setEnabled(bl);
        this.note_combo.setEnabled(bl);
        this.unit_label.setEnabled(bl);
    }

    public void setPPQ(int n) {
        this.ppq = n;
        this.model.setPPQ(this.ppq);
    }

    public int getDuration() {
        return this.model.getDuration();
    }

    public void setDuration(int n) {
        this.model.setDuration(n);
    }

    class DurationModel
    extends SpinnerNumberModel {
        public DurationModel() {
            super(DurationForm.this.ppq, 1, DurationForm.this.ppq * 4 * 4, 1);
        }

        public void setDuration(int n) {
            this.setValue(new Integer(n));
        }

        public int getDuration() {
            return this.getNumber().intValue();
        }

        public void setPPQ(int n) {
            this.setMaximum(Integer.valueOf(n * 4 * 4));
            this.setDuration(n);
        }
    }

    class NoteComboBox
    extends JComboBox {
        public NoteComboBox() {
            this.setRenderer(new NoteRenderer());
            this.addItem(new NoteIcon(14));
            this.addItem(new NoteIcon(142));
            this.addItem(new NoteIcon(141));
            this.addItem(new NoteIcon(140));
            this.addItem(new NoteIcon(139));
            this.addItem(new NoteIcon(138));
            this.addItem(new NoteIcon(137));
            this.addItem(new NoteIcon(136));
            this.addItem(new NoteIcon(135));
            this.addItem(new NoteIcon(134));
            this.addItem(new NoteIcon(133));
            this.addItem(new NoteIcon(132));
            this.addItem(new NoteIcon(130));
            this.setMaximumRowCount(16);
            this.setSelectedIndex(5);
        }

        public int getDuration() {
            NoteIcon noteIcon = (NoteIcon)this.getSelectedItem();
            if (noteIcon == null) {
                return -1;
            }
            return noteIcon.getDuration();
        }

        public void setDuration(int n) {
            int n2 = this.getItemCount();
            for (int i = 1; i < n2; ++i) {
                NoteIcon noteIcon = (NoteIcon)this.getItemAt(i);
                int n3 = noteIcon.getDuration();
                if (n3 < 0 || n3 != n) continue;
                this.setSelectedItem(noteIcon);
                return;
            }
            this.setSelectedIndex(0);
        }
    }

    class NoteRenderer
    extends JLabel
    implements ListCellRenderer {
        public NoteRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            NoteIcon noteIcon = (NoteIcon)object;
            this.setIcon(noteIcon);
            int n2 = noteIcon.getDuration();
            this.setText(n2 < 0 ? null : "" + n2);
            this.setFont(jList.getFont());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class NoteIcon
    extends ButtonIcon {
        public NoteIcon(int n) {
            super(n);
        }

        public int getDuration() {
            if (!this.isMusicalNote()) {
                return -1;
            }
            int n = DurationForm.this.ppq * 4 >> this.getMusicalNoteValueIndex();
            if (this.isDottedMusicalNote()) {
                n += n / 2;
            }
            return n;
        }
    }
}

