/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class MidiDeviceFrame
extends JInternalFrame {
    MidiConnecterList list;

    public MidiDeviceFrame(MidiConnecterListModel midiConnecterListModel) {
        super(null, true, true, false, false);
        if (midiConnecterListModel.hasTx()) {
            if (midiConnecterListModel.hasRx()) {
                this.setTitle("" + midiConnecterListModel);
            } else {
                this.setTitle("[IN] " + midiConnecterListModel);
            }
        } else if (midiConnecterListModel.hasRx()) {
            this.setTitle("[OUT] " + midiConnecterListModel);
        } else {
            this.setTitle("[No IN/OUT] " + midiConnecterListModel);
        }
        this.list = new MidiConnecterList(midiConnecterListModel);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
                MidiConnecterListModel midiConnecterListModel = MidiDeviceFrame.this.list.getModel();
                if (midiConnecterListModel.device.isOpen()) {
                    return;
                }
                MidiDeviceFrame.this.setVisible(false);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                MidiConnecterListModel midiConnecterListModel = MidiDeviceFrame.this.list.getModel();
                midiConnecterListModel.closeDevice();
                if (midiConnecterListModel.device.isOpen()) {
                    return;
                }
                MidiDeviceFrame.this.setVisible(false);
            }
        });
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.add(new JScrollPane(this.list));
        if (midiConnecterListModel.hasTx()) {
            Insets insets = new Insets(0, 0, 0, 0);
            JButton jButton = new JButton("New Tx");
            jButton.setMargin(insets);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MidiDeviceFrame.this.list.getModel().getUnconnectedTransmitter();
                }
            });
            JButton jButton2 = new JButton("Close Tx");
            jButton2.setMargin(insets);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MidiDeviceFrame.this.list.getModel().closeTransmitter(MidiDeviceFrame.this.list.getSelectedTransmitter());
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this.add(jPanel);
        }
    }

    public Rectangle getListCellBounds(int n) {
        Rectangle rectangle = this.list.getCellBounds(n, n);
        if (rectangle == null) {
            return null;
        }
        rectangle.translate(this.getRootPane().getX() + this.getContentPane().getX(), this.getRootPane().getY() + this.getContentPane().getY());
        return rectangle;
    }
}

