/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

class MidiDeviceManager
extends Vector<MidiConnecterListModel> {
    private Sequencer sequencer = null;
    SpeedSliderModel speed_slider_model = null;
    SequencerTimeRangeModel time_range_model = null;
    MidiEditor editor_dialog = null;
    MidiConnecterListModel first_midi_out_model = null;

    public MidiDeviceManager(Vector<VirtualMidiDevice> vector) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiConnecterListModel[] midiConnecterListModelArray = new MidiConnecterListModel[vector.size()];
        MidiConnecterListModel midiConnecterListModel = null;
        MidiConnecterListModel midiConnecterListModel2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            midiConnecterListModelArray[i] = this.addMidiDevice(vector.get(i));
        }
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            midiConnecterListModel = this.addMidiDevice(this.sequencer);
            this.speed_slider_model = new SpeedSliderModel(this.sequencer);
            this.time_range_model = new SequencerTimeRangeModel(this);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            System.out.println("MIDI Chord Helper : MIDI sequencer unavailable");
            midiUnavailableException.printStackTrace();
        }
        for (MidiDevice.Info object : infoArray) {
            MidiConnecterListModel[] midiConnecterListModelArray2;
            try {
                midiConnecterListModelArray2 = MidiSystem.getMidiDevice(object);
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
                continue;
            }
            if (midiConnecterListModelArray2 instanceof Sequencer) continue;
            if (midiConnecterListModelArray2 instanceof Synthesizer) {
                try {
                    this.addMidiDevice(MidiSystem.getSynthesizer());
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    System.out.println("MIDI Chord Helper : Java internal MIDI synthesizer unavailable");
                    midiUnavailableException.printStackTrace();
                }
                continue;
            }
            MidiConnecterListModel midiConnecterListModel3 = this.addMidiDevice((MidiDevice)midiConnecterListModelArray2);
            if (midiConnecterListModel3.hasRx() && this.first_midi_out_model == null) {
                this.first_midi_out_model = midiConnecterListModel3;
            }
            if (!midiConnecterListModel3.hasTx() || midiConnecterListModel2 != null) continue;
            midiConnecterListModel2 = midiConnecterListModel3;
        }
        try {
            for (MidiConnecterListModel midiConnecterListModel4 : midiConnecterListModelArray) {
                midiConnecterListModel4.openDevice();
            }
            if (midiConnecterListModel2 != null) {
                midiConnecterListModel2.openDevice();
            }
            if (midiConnecterListModel != null) {
                midiConnecterListModel.openDevice();
            }
            if (this.first_midi_out_model != null) {
                this.first_midi_out_model.openDevice();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        for (MidiConnecterListModel midiConnecterListModel5 : midiConnecterListModelArray) {
            for (MidiConnecterListModel midiConnecterListModel6 : midiConnecterListModelArray) {
                midiConnecterListModel5.connectToReceiverOf(midiConnecterListModel6);
            }
            midiConnecterListModel5.connectToReceiverOf(midiConnecterListModel);
            midiConnecterListModel5.connectToReceiverOf(this.first_midi_out_model);
        }
        if (midiConnecterListModel2 != null) {
            for (MidiConnecterListModel midiConnecterListModel7 : midiConnecterListModelArray) {
                midiConnecterListModel2.connectToReceiverOf(midiConnecterListModel7);
            }
            midiConnecterListModel2.connectToReceiverOf(midiConnecterListModel);
            midiConnecterListModel2.connectToReceiverOf(this.first_midi_out_model);
        }
        if (midiConnecterListModel != null) {
            for (MidiConnecterListModel midiConnecterListModel8 : midiConnecterListModelArray) {
                midiConnecterListModel.connectToReceiverOf(midiConnecterListModel8);
            }
            midiConnecterListModel.connectToReceiverOf(this.first_midi_out_model);
        }
    }

    private MidiConnecterListModel addMidiDevice(MidiDevice midiDevice) {
        MidiConnecterListModel midiConnecterListModel = new MidiConnecterListModel(midiDevice, this);
        this.addElement(midiConnecterListModel);
        return midiConnecterListModel;
    }

    public void setMidiEditor(MidiEditor midiEditor) {
        midiEditor.device_manager = this;
        this.editor_dialog = midiEditor;
        MidiConnecterListModel midiConnecterListModel = this.addMidiDevice(this.editor_dialog.midi_device);
        try {
            midiConnecterListModel.openDevice();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        midiConnecterListModel.connectToReceiverOf(this.first_midi_out_model);
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public boolean isRecordable() {
        return this.editor_dialog != null && this.editor_dialog.isRecordable();
    }

    public void resetMicrosecondPosition() {
        for (MidiConnecterListModel midiConnecterListModel : this) {
            midiConnecterListModel.resetMicrosecondPosition();
        }
    }
}

