/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PianoKeyboard
extends JComponent {
    public static final int MIN_OCTAVES = 3;
    public static final int MAX_OCTAVES = 11;
    public static final Color DARK_PINK = new Color(255, 80, 128);
    int binded_key_position;
    String binded_key_chars;
    Dimension white_key_size;
    Dimension black_key_size;
    boolean is_dark = false;
    float width_per_octave = 120.0f;
    PianoKey[] keys = null;
    PianoKey[] black_keys = null;
    PianoKey[] white_keys = null;
    PianoKey[] binded_keys = null;
    DefaultBoundedRangeModel octave_range_model;
    DefaultBoundedRangeModel octave_size_model;
    VelocityModel velocity_model = new VelocityModel();
    DefaultMidiChannelComboBoxModel midi_ch_combobox_model = new DefaultMidiChannelComboBoxModel();
    NoteList selected_keys = new NoteList();
    private int max_selectable = 1;
    Music.Key key_signature = null;
    Music.Chord chord = null;
    EventListenerList listenerList = new EventListenerList();
    public ChordMatrix chord_matrix;
    public ChordDisplay chord_display;
    public AnoGakkiLayeredPane ano_gakki_layered_pane;
    public MidiChannelButtonSelecter midi_ch_button_selecter;
    NoteList[] channel_notes = new NoteList[16];
    int[] pitch_bend_values = new int[16];
    int[] pitch_bend_sensitivities = new int[16];
    int[] modulations = new int[16];
    VirtualMidiDevice midi_device = new AbstractVirtualMidiDevice(){
        {
            this.info = new MyInfo();
            this.setReceiver(new AbstractMidiStatus(){
                {
                    for (int i = 0; i < 16; ++i) {
                        this.add(new MidiChannelStatus(i));
                    }
                }
            });
        }

        class MyInfo
        extends MidiDevice.Info {
            protected MyInfo() {
                super("MIDI Keyboard", "Unknown vendor", "Software MIDI keyboard", "Ver.20091003");
            }
        }
    };

    public MidiChannel getSelectedChannel() {
        return this.midi_device.getChannels()[this.midi_ch_combobox_model.getSelectedChannel()];
    }

    public void note(boolean bl, int n) {
        MidiChannel midiChannel = this.getSelectedChannel();
        int n2 = this.velocity_model.getValue();
        if (bl) {
            midiChannel.noteOn(n, n2);
        } else {
            midiChannel.noteOff(n, n2);
        }
    }

    public void noteOn(int n) {
        this.note(true, n);
    }

    public void noteOff(int n) {
        this.note(false, n);
    }

    public PianoKeyboard() {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PianoKeyboard.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PianoKeyboard.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = PianoKeyboard.this.getNote(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                int n2 = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                if (PianoKeyboard.this.channel_notes[n2].contains(n)) {
                    return;
                }
                PianoKeyboard.this.chord = null;
                PianoKeyboard.this.keyOn(n2, n);
                PianoKeyboard.this.noteOn(n);
                PianoKeyboard.this.firePianoKeyPressed(n, mouseEvent);
                PianoKeyboard.this.requestFocusInWindow();
                PianoKeyboard.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                if (PianoKeyboard.this.channel_notes[n].isEmpty()) {
                    return;
                }
                int n2 = (Integer)PianoKeyboard.this.channel_notes[n].poll();
                PianoKeyboard.this.keyOff(n, n2);
                PianoKeyboard.this.noteOff(n2);
                PianoKeyboard.this.firePianoKeyReleased(n2, mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = PianoKeyboard.this.getNote(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                int n2 = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                if (PianoKeyboard.this.channel_notes[n2].contains(n)) {
                    return;
                }
                if (PianoKeyboard.this.channel_notes[n2].size() > 0) {
                    int n3 = (Integer)PianoKeyboard.this.channel_notes[n2].poll();
                    PianoKeyboard.this.keyOff(n2, n3);
                    PianoKeyboard.this.noteOff(n3);
                    PianoKeyboard.this.firePianoKeyReleased(n3, mouseEvent);
                }
                PianoKeyboard.this.keyOn(n2, n);
                PianoKeyboard.this.noteOn(n);
                PianoKeyboard.this.firePianoKeyPressed(n, mouseEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                block11: {
                    block10: {
                        int n;
                        block9: {
                            block8: {
                                n = keyEvent.getKeyCode();
                                if (n == 37) break block8;
                                if (n != 226) break block9;
                            }
                            PianoKeyboard.this.octave_range_model.setValue(PianoKeyboard.this.octave_range_model.getValue() - 1);
                            return;
                        }
                        if (n == 39) break block10;
                        if (n != 227) break block11;
                    }
                    PianoKeyboard.this.octave_range_model.setValue(PianoKeyboard.this.octave_range_model.getValue() + 1);
                    return;
                }
                int n = PianoKeyboard.this.getNote(keyEvent);
                if (n < 0) {
                    return;
                }
                int n2 = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                if (PianoKeyboard.this.channel_notes[n2].contains(n)) {
                    return;
                }
                PianoKeyboard.this.chord = null;
                PianoKeyboard.this.keyOn(n2, n);
                PianoKeyboard.this.noteOn(n);
                PianoKeyboard.this.firePianoKeyPressed(n, keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                int n2 = PianoKeyboard.this.getNote(keyEvent);
                if (n2 < 0 || !PianoKeyboard.this.channel_notes[n].contains(n2)) {
                    return;
                }
                PianoKeyboard.this.keyOff(n, n2);
                PianoKeyboard.this.noteOff(n2);
                PianoKeyboard.this.firePianoKeyReleased(n2, keyEvent);
            }
        });
        int n = this.getPerferredOctaves();
        this.octave_size_model = new DefaultBoundedRangeModel(n, 0, 3, 11);
        this.octave_size_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PianoKeyboard.this.fireOctaveResized(changeEvent);
                PianoKeyboard.this.octaveSizeChanged();
            }
        });
        this.octave_range_model = new DefaultBoundedRangeModel((11 - n) / 2, n, 0, 11);
        this.octave_range_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PianoKeyboard.this.fireOctaveMoved(changeEvent);
                PianoKeyboard.this.checkOutOfBounds();
                PianoKeyboard.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PianoKeyboard.this.octave_size_model.setValue(PianoKeyboard.this.getPerferredOctaves());
                PianoKeyboard.this.octaveSizeChanged();
            }
        });
        this.midi_ch_combobox_model.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                int n;
                int n2 = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                Iterator iterator = PianoKeyboard.this.channel_notes[n2].iterator();
                while (iterator.hasNext() && !PianoKeyboard.this.autoScroll(n = ((Integer)iterator.next()).intValue())) {
                }
                PianoKeyboard.this.repaint();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        PianoKey pianoKey;
        if (this.keys == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics2D.setBackground(this.getBackground());
        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(this.is_dark ? Color.gray : Color.white);
        for (PianoKey pianoKey2 : this.white_keys) {
            pianoKey2.paintKey(graphics2D);
        }
        NoteList noteList = (NoteList)this.channel_notes[this.midi_ch_combobox_model.getSelectedChannel()].clone();
        NoteList noteList2 = (NoteList)this.selected_keys.clone();
        Object object = noteList.iterator();
        while (object.hasNext()) {
            int n3 = (Integer)object.next();
            pianoKey = this.getPianoKey(n3);
            if (pianoKey == null || pianoKey.is_black) continue;
            pianoKey.paintKey(graphics2D, true);
        }
        graphics2D.setColor(this.getForeground());
        for (PianoKey pianoKey3 : this.black_keys) {
            pianoKey3.paintKey(graphics2D);
        }
        graphics2D.setColor(Color.gray);
        object = noteList.iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            pianoKey = this.getPianoKey(n2);
            if (pianoKey == null || !pianoKey.is_black) continue;
            pianoKey.paintKey(graphics2D, true);
        }
        object = noteList2.iterator();
        while (object.hasNext()) {
            int n4;
            n2 = (Integer)object.next();
            pianoKey = this.getPianoKey(n2);
            if (pianoKey == null) continue;
            int n5 = n = this.key_signature == null || this.key_signature.isOnScale(n2) ? 1 : 0;
            if (this.chord != null && (n4 = this.chord.indexOf(n2)) >= 0) {
                graphics2D.setColor(Music.Chord.index_colors[n4]);
            } else {
                graphics2D.setColor(this.is_dark && n != 0 ? Color.pink : DARK_PINK);
            }
            pianoKey.paintIndicator(graphics2D, false, this.pitch_bend_values[this.midi_ch_combobox_model.getSelectedChannel()]);
            if (n != 0) continue;
            graphics2D.setColor(Color.white);
            pianoKey.paintIndicator(graphics2D, true);
        }
        object = noteList.iterator();
        while (object.hasNext()) {
            int n6;
            n2 = (Integer)object.next();
            pianoKey = this.getPianoKey(n2);
            if (pianoKey == null) continue;
            int n7 = n = this.key_signature == null || this.key_signature.isOnScale(n2) ? 1 : 0;
            if (this.chord != null && (n6 = this.chord.indexOf(n2)) >= 0) {
                graphics2D.setColor(Music.Chord.index_colors[n6]);
            } else {
                graphics2D.setColor(this.is_dark && n != 0 ? Color.pink : DARK_PINK);
            }
            pianoKey.paintIndicator(graphics2D, false, this.pitch_bend_values[this.midi_ch_combobox_model.getSelectedChannel()]);
            if (n != 0) continue;
            graphics2D.setColor(Color.white);
            pianoKey.paintIndicator(graphics2D, true);
        }
        if (this.isFocusOwner()) {
            for (PianoKey pianoKey4 : this.binded_keys) {
                graphics2D.setColor(pianoKey4.is_black ? Color.gray.brighter() : (this.is_dark ? this.getForeground() : this.getForeground().brighter()));
                pianoKey4.paintKeyBinding(graphics2D);
            }
        }
    }

    protected void firePianoKeyPressed(int n, InputEvent inputEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PianoKeyboardListener.class) continue;
            ((PianoKeyboardListener)objectArray[i + 1]).pianoKeyPressed(n, inputEvent);
        }
    }

    protected void firePianoKeyReleased(int n, InputEvent inputEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PianoKeyboardListener.class) continue;
            ((PianoKeyboardListener)objectArray[i + 1]).pianoKeyReleased(n, inputEvent);
        }
    }

    protected void fireOctaveMoved(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PianoKeyboardListener.class) continue;
            ((PianoKeyboardListener)objectArray[i + 1]).octaveMoved(changeEvent);
        }
    }

    protected void fireOctaveResized(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PianoKeyboardListener.class) continue;
            ((PianoKeyboardListener)objectArray[i + 1]).octaveResized(changeEvent);
        }
    }

    public PianoKey getPianoKey(int n) {
        int n2 = n - this.octave_range_model.getValue() * 12;
        return n2 >= 0 && n2 < this.keys.length ? this.keys[n2] : null;
    }

    private int getNote(Point point) {
        PianoKey pianoKey = this.getPianoKey(point);
        return pianoKey == null ? -1 : pianoKey.getNote(this.getChromaticOffset());
    }

    private PianoKey getPianoKey(Point point) {
        PianoKey pianoKey;
        int n = point.x / this.white_key_size.width;
        int n2 = n / 7;
        int n3 = (n -= n2 * 7) * 2 + n2 * 12;
        if (n >= 3) {
            --n3;
        }
        if (n3 < 0 || n3 > this.keys.length - 1) {
            return null;
        }
        if (point.y > this.black_key_size.height) {
            return this.keys[n3];
        }
        if (n3 > 0) {
            pianoKey = this.keys[n3 - 1];
            if (pianoKey.is_black && !pianoKey.out_of_bounds && pianoKey.contains(point)) {
                return pianoKey;
            }
        }
        if (n3 < this.keys.length - 1) {
            pianoKey = this.keys[n3 + 1];
            if (pianoKey.is_black && !pianoKey.out_of_bounds && pianoKey.contains(point)) {
                return pianoKey;
            }
        }
        return this.keys[n3];
    }

    private PianoKey getPianoKey(KeyEvent keyEvent) {
        int n = this.binded_key_chars.indexOf(keyEvent.getKeyChar());
        return n >= 0 ? this.keys[this.binded_key_position + n] : null;
    }

    private int getNote(KeyEvent keyEvent) {
        PianoKey pianoKey = this.getPianoKey(keyEvent);
        return pianoKey == null ? -1 : pianoKey.getNote(this.getChromaticOffset());
    }

    void changeKeyBinding(int n, String string) {
        this.binded_key_chars = string;
        this.binded_keys = new PianoKey[this.binded_key_chars.length()];
        this.binded_key_position = n;
        for (int i = 0; i < this.binded_key_chars.length(); ++i) {
            PianoKey pianoKey;
            this.binded_keys[i] = pianoKey = this.keys[this.binded_key_position + i];
            pianoKey.binded_key_char = this.binded_key_chars.substring(i, i + 1);
        }
        this.repaint();
    }

    private void checkOutOfBounds() {
        if (this.keys == null) {
            return;
        }
        for (PianoKey pianoKey : this.keys) {
            pianoKey.getNote(this.getChromaticOffset());
        }
    }

    void keyOff(int n, int n2) {
        if (n2 < 0 || n < 0 || n >= this.channel_notes.length) {
            return;
        }
        this.channel_notes[n].remove((Object)n2);
        if (n == this.midi_ch_combobox_model.getSelectedChannel()) {
            this.repaint();
        }
    }

    void keyOn(int n, int n2) {
        if (n2 < 0 || n < 0 || n >= this.channel_notes.length) {
            return;
        }
        this.channel_notes[n].add(n2);
        this.setSelectedNote(n, n2);
    }

    boolean autoScroll(int n) {
        if (this.octave_range_model == null || this.keys == null) {
            return false;
        }
        int n2 = n - this.getChromaticOffset();
        if (n2 < 0) {
            this.octave_range_model.setValue(this.octave_range_model.getValue() - -n2 / 12 - 1);
            return true;
        }
        if (n2 >= this.keys.length) {
            this.octave_range_model.setValue(this.octave_range_model.getValue() + (n2 - this.keys.length) / 12 + 1);
            return true;
        }
        return false;
    }

    void addPianoKeyboardListener(PianoKeyboardListener pianoKeyboardListener) {
        this.listenerList.add(PianoKeyboardListener.class, pianoKeyboardListener);
    }

    void removePianoKeyboardListener(PianoKeyboardListener pianoKeyboardListener) {
        this.listenerList.remove(PianoKeyboardListener.class, pianoKeyboardListener);
    }

    int countKeyOn() {
        return this.channel_notes[this.midi_ch_combobox_model.getSelectedChannel()].size();
    }

    int countKeyOn(int n) {
        return this.channel_notes[n].size();
    }

    void allKeysOff(int n, int n2) {
        if (!this.selected_keys.isEmpty()) {
            return;
        }
        switch (n2) {
            case -1: {
                this.selected_keys = (NoteList)this.channel_notes[n].clone();
                break;
            }
            case 1: {
                this.selected_keys.add(this.channel_notes[n].get(this.channel_notes[n].size() - 1));
                break;
            }
        }
        this.channel_notes[n].clear();
        if (this.midi_ch_combobox_model.getSelectedChannel() == n) {
            this.repaint();
        }
    }

    void clear() {
        this.selected_keys.clear();
        this.channel_notes[this.midi_ch_combobox_model.getSelectedChannel()].clear();
        this.chord = null;
        this.repaint();
    }

    int getNote() {
        int n = this.midi_ch_combobox_model.getSelectedChannel();
        switch (this.channel_notes[n].size()) {
            case 1: {
                return (Integer)this.channel_notes[n].get(0);
            }
            case 0: {
                if (this.selected_keys.size() == 1) {
                    return (Integer)this.selected_keys.get(0);
                }
                return -1;
            }
        }
        return -1;
    }

    void setSelectedNote(int n) {
        this.setSelectedNote(this.midi_ch_combobox_model.getSelectedChannel(), n);
    }

    void setSelectedNote(int n, int n2) {
        int n3;
        if (n != this.midi_ch_combobox_model.getSelectedChannel()) {
            return;
        }
        this.selected_keys.add(n2);
        int n4 = n3 = this.chord == null ? this.max_selectable : this.chord.numberOfNotes();
        while (this.selected_keys.size() > n3) {
            this.selected_keys.poll();
        }
        if (!this.autoScroll(n2)) {
            this.repaint();
        }
    }

    Integer[] getSelectedNotes() {
        return this.selected_keys.toArray(new Integer[0]);
    }

    Music.Chord getChord() {
        return this.chord;
    }

    void setChord(Music.Chord chord) {
        this.chord = chord;
        this.chord_display.setChord(this.chord);
    }

    void setKeySignature(Music.Key key) {
        this.key_signature = key;
        this.repaint();
    }

    void setMaxSelectable(int n) {
        this.max_selectable = n;
    }

    int getMaxSelectable() {
        return this.max_selectable;
    }

    int getChromaticOffset() {
        return this.octave_range_model.getValue() * 12;
    }

    int getOctaves() {
        return this.octave_size_model.getValue();
    }

    private int getPerferredOctaves() {
        int n = Math.round((float)this.getWidth() / this.width_per_octave);
        if (n > 11) {
            n = 11;
        } else if (n < 3) {
            n = 3;
        }
        return n;
    }

    private void octaveSizeChanged() {
        int n = this.octave_size_model.getValue();
        String string = "zsxdcvgbhnjm,l.;/\\]";
        Dimension dimension = this.getSize();
        if (dimension.width == 0) {
            return;
        }
        this.white_key_size = new Dimension((dimension.width - 1) / (n * 7 + 1), dimension.height - 1);
        this.black_key_size = new Dimension(this.white_key_size.width * 3 / 4, this.white_key_size.height * 3 / 5);
        Dimension dimension2 = new Dimension(this.white_key_size.width / 2, this.white_key_size.height / 6);
        this.octave_range_model.setExtent(n);
        this.octave_range_model.setValue((11 - n) / 2);
        this.width_per_octave = dimension.width / n;
        this.keys = new PianoKey[n * 12 + 1];
        Vector<PianoKey> vector = new Vector<PianoKey>();
        Vector<PianoKey> vector2 = new Vector<PianoKey>();
        Point point = new Point(1, 1);
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.keys.length) {
            PianoKey pianoKey;
            switch (n2) {
                case 12: {
                    bl2 = true;
                    n2 = 0;
                    break;
                }
                case 5: {
                    bl2 = false;
                    break;
                }
            }
            point.x = this.white_key_size.width * (n3 / 12 * 7 + (n2 + (bl2 ? 1 : 2)) / 2);
            if (Music.isOnScale(n2)) {
                pianoKey = new PianoKey(point, this.white_key_size, dimension2);
                pianoKey.is_black = false;
                vector2.add(pianoKey);
            } else {
                point.x = point.x - ((bl2 ? 5 : 12) - n2) / 2 * this.black_key_size.width / (bl2 ? 3 : 4);
                pianoKey = new PianoKey(point, this.black_key_size, dimension2);
                pianoKey.is_black = true;
                vector.add(pianoKey);
            }
            this.keys[n3] = pianoKey;
            pianoKey.position = n3++;
            ++n2;
        }
        this.white_keys = vector2.toArray(new PianoKey[1]);
        this.black_keys = vector.toArray(new PianoKey[1]);
        this.changeKeyBinding((n - 1) / 2 * 12, string);
        this.checkOutOfBounds();
    }

    void setDarkMode(boolean bl) {
        this.is_dark = bl;
        this.setBackground(bl ? Color.black : null);
    }

    class PianoKey
    extends Rectangle {
        public boolean is_black;
        public int position;
        public String binded_key_char;
        public Rectangle indicator;
        public boolean out_of_bounds;

        public PianoKey(Point point, Dimension dimension, Dimension dimension2) {
            super(point, dimension);
            this.is_black = false;
            this.position = 0;
            this.binded_key_char = null;
            this.out_of_bounds = false;
            Point point2 = new Point(point.x + (dimension.width - dimension2.width) / 2, point.y + dimension.height - dimension2.height - dimension2.height / 2 + 2);
            this.indicator = new Rectangle(point2, dimension2);
        }

        int getNote(int n) {
            int n2 = this.position + n;
            this.out_of_bounds = n2 > 127;
            return this.out_of_bounds ? -1 : n2;
        }

        boolean paintKey(Graphics2D graphics2D, boolean bl) {
            if (this.out_of_bounds) {
                return false;
            }
            graphics2D.fill3DRect(this.x, this.y, this.width, this.height, !bl);
            return true;
        }

        boolean paintKey(Graphics2D graphics2D) {
            return this.paintKey(graphics2D, false);
        }

        boolean paintKeyBinding(Graphics2D graphics2D) {
            if (this.binded_key_char == null) {
                return false;
            }
            graphics2D.drawString(this.binded_key_char, this.x + this.width / 3, this.indicator.y - 2);
            return true;
        }

        boolean paintIndicator(Graphics2D graphics2D, boolean bl, int n) {
            if (bl) {
                graphics2D.fillOval(this.indicator.x + this.indicator.width / 4, this.indicator.y + this.indicator.height / 4 + 1, this.indicator.width / 2, this.indicator.height / 2);
            } else {
                int n2 = PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel();
                int n3 = PianoKeyboard.this.pitch_bend_sensitivities[n2];
                if (n3 == 0) {
                    n3 = 2;
                }
                int n4 = 7 * PianoKeyboard.this.white_key_size.width * n3 * (n - 8192) / 98304;
                int n5 = this.indicator.height * PianoKeyboard.this.modulations[n2] / 256;
                int n6 = n5 / 2;
                graphics2D.fillOval(this.indicator.x + (n4 < 0 ? n4 : 0), this.indicator.y - n6, this.indicator.width + (n4 < 0 ? -n4 : n4), this.indicator.height + n5);
            }
            return true;
        }

        boolean paintIndicator(Graphics2D graphics2D, boolean bl) {
            return this.paintIndicator(graphics2D, bl, 0);
        }
    }

    class MidiChannelStatus
    extends AbstractMidiChannelStatus {
        public MidiChannelStatus(int n) {
            super(n);
            PianoKeyboard.this.channel_notes[n] = new NoteList();
            PianoKeyboard.this.pitch_bend_sensitivities[n] = 2;
        }

        @Override
        public void fireRpnChanged() {
            if (this.data_for != 1) {
                return;
            }
            if (this.controller_values[101] != 0) {
                return;
            }
            switch (this.controller_values[100]) {
                case 0: {
                    if (this.controller_values[6] == 0) {
                        return;
                    }
                    PianoKeyboard.this.pitch_bend_sensitivities[this.channel] = this.controller_values[6];
                }
            }
        }

        @Override
        public void noteOff(int n, int n2) {
            this.noteOff(n);
        }

        @Override
        public void noteOff(int n) {
            PianoKeyboard.this.keyOff(this.channel, n);
            if (PianoKeyboard.this.chord_matrix != null && !this.isRhythmPart()) {
                PianoKeyboard.this.chord_matrix.note(this.channel, false, n);
            }
            if (PianoKeyboard.this.midi_ch_button_selecter != null) {
                PianoKeyboard.this.midi_ch_button_selecter.repaint();
            }
        }

        @Override
        public void noteOn(int n, int n2) {
            if (n2 <= 0) {
                this.noteOff(n);
                return;
            }
            PianoKeyboard.this.keyOn(this.channel, n);
            if (PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel() == this.channel) {
                PianoKey pianoKey;
                if (PianoKeyboard.this.chord_display != null) {
                    if (PianoKeyboard.this.chord_matrix != null && PianoKeyboard.this.chord_matrix.isPlaying()) {
                        PianoKeyboard.this.chord_display.setNote(-1);
                    } else {
                        PianoKeyboard.this.chord_display.setNote(n, this.isRhythmPart());
                    }
                }
                if (PianoKeyboard.this.ano_gakki_layered_pane != null && (pianoKey = PianoKeyboard.this.getPianoKey(n)) != null) {
                    PianoKeyboard.this.ano_gakki_layered_pane.start((Component)PianoKeyboard.this, pianoKey.indicator);
                }
            }
            if (PianoKeyboard.this.chord_matrix != null && !this.isRhythmPart()) {
                PianoKeyboard.this.chord_matrix.note(this.channel, true, n);
            }
            if (PianoKeyboard.this.midi_ch_button_selecter != null) {
                PianoKeyboard.this.midi_ch_button_selecter.repaint();
            }
        }

        @Override
        public void allNotesOff() {
            PianoKeyboard.this.allKeysOff(this.channel, -1);
            if (PianoKeyboard.this.chord_matrix != null) {
                PianoKeyboard.this.chord_matrix.clearIndicators();
            }
        }

        @Override
        public void setPitchBend(int n) {
            super.setPitchBend(n);
            PianoKeyboard.this.pitch_bend_values[this.channel] = n;
            this.repaintNotes();
        }

        @Override
        public void resetAllControllers() {
            super.resetAllControllers();
            PianoKeyboard.this.pitch_bend_values[this.channel] = 8192;
            PianoKeyboard.this.modulations[this.channel] = 0;
            this.repaintNotes();
        }

        @Override
        public void controlChange(int n, int n2) {
            super.controlChange(n, n2);
            switch (n) {
                case 1: {
                    PianoKeyboard.this.modulations[this.channel] = n2;
                    this.repaintNotes();
                }
            }
        }

        private void repaintNotes() {
            if (PianoKeyboard.this.midi_ch_combobox_model.getSelectedChannel() != this.channel || PianoKeyboard.this.channel_notes[this.channel] == null) {
                return;
            }
            if (PianoKeyboard.this.channel_notes[this.channel].size() > 0 || PianoKeyboard.this.selected_keys.size() > 0) {
                PianoKeyboard.this.repaint();
            }
        }
    }

    class NoteList
    extends LinkedList<Integer> {
        NoteList() {
        }
    }
}

