/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;

class PianoKeyboardPanel
extends JPanel {
    PianoKeyboard keyboard = new PianoKeyboard();
    JSlider octave_size_slider = new JSlider();
    JScrollBar octave_selecter = new JScrollBar(0);
    JPanel octave_bar = new JPanel();

    public PianoKeyboardPanel() {
        this.octave_size_slider.setToolTipText("Octave size");
        this.octave_selecter.setToolTipText("Octave position");
        this.keyboard.addPianoKeyboardListener(new PianoKeyboardAdapter(){

            @Override
            public void octaveResized(ChangeEvent changeEvent) {
                PianoKeyboardPanel.this.octave_selecter.setBlockIncrement(PianoKeyboardPanel.this.keyboard.getOctaves());
            }
        });
        this.octave_selecter.setModel(this.keyboard.octave_range_model);
        this.octave_selecter.setBlockIncrement(this.keyboard.getOctaves());
        this.octave_size_slider.setModel(this.keyboard.octave_size_model);
        this.octave_size_slider.setMinimumSize(new Dimension(100, 18));
        this.octave_size_slider.setMaximumSize(new Dimension(100, 18));
        this.octave_size_slider.setPreferredSize(new Dimension(100, 18));
        this.octave_bar.setLayout(new BoxLayout(this.octave_bar, 0));
        this.octave_bar.add(this.octave_selecter);
        this.octave_bar.add(Box.createHorizontalStrut(5));
        this.octave_bar.add(this.octave_size_slider);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.octave_bar);
        this.add(this.keyboard);
        this.setAlignmentX(0.5f);
    }

    public void setDarkMode(boolean bl) {
        Color color = bl ? Color.black : null;
        this.octave_selecter.setBackground(color);
        this.octave_size_slider.setBackground(color);
        this.octave_bar.setBackground(color);
        this.keyboard.setDarkMode(bl);
    }
}

