/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

class SequenceIndex {
    private Track timesig_positions;
    private Track tempo_positions;
    private Track keysig_positions;
    private Sequence tmp_seq;
    public int ticks_per_whole_note;
    public int last_measure;
    public int last_beat;
    public int last_extra_tick;
    public int ticks_per_beat;
    public byte timesig_upper;
    public byte timesig_lower_index;

    public SequenceIndex(Sequence sequence) {
        try {
            Track[] trackArray;
            int n = sequence.getResolution();
            this.ticks_per_whole_note = n * 4;
            this.tmp_seq = new Sequence(0.0f, n, 3);
            Track[] trackArray2 = this.tmp_seq.getTracks();
            this.timesig_positions = trackArray2[0];
            this.tempo_positions = trackArray2[1];
            this.keysig_positions = trackArray2[2];
            for (Track track : trackArray = sequence.getTracks()) {
                block8: for (int i = 0; i < track.size(); ++i) {
                    MidiEvent midiEvent = track.get(i);
                    MidiMessage midiMessage = midiEvent.getMessage();
                    if (!(midiMessage instanceof MetaMessage)) continue;
                    switch (((MetaMessage)midiMessage).getType()) {
                        case 81: {
                            this.tempo_positions.add(midiEvent);
                            continue block8;
                        }
                        case 88: {
                            this.timesig_positions.add(midiEvent);
                            continue block8;
                        }
                        case 89: {
                            this.keysig_positions.add(midiEvent);
                            continue block8;
                        }
                    }
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private MetaMessage lastMessageAt(Track track, long l) {
        if (track == null) {
            return null;
        }
        for (int i = track.size() - 1; i >= 0; --i) {
            MetaMessage metaMessage;
            MidiEvent midiEvent = track.get(i);
            if (midiEvent.getTick() > l || (metaMessage = (MetaMessage)midiEvent.getMessage()).getType() == 47) continue;
            return metaMessage;
        }
        return null;
    }

    public MetaMessage lastTimeSignatureAt(long l) {
        return this.lastMessageAt(this.timesig_positions, l);
    }

    public MetaMessage lastKeySignatureAt(long l) {
        return this.lastMessageAt(this.keysig_positions, l);
    }

    public MetaMessage lastTempoAt(long l) {
        return this.lastMessageAt(this.tempo_positions, l);
    }

    public int getResolution() {
        return this.tmp_seq.getResolution();
    }

    int tickToMeasure(long l) {
        int n = 0;
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        byte[] byArray = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        this.last_measure = 0;
        int n2 = 0;
        this.timesig_upper = (byte)4;
        this.timesig_lower_index = (byte)2;
        if (this.timesig_positions != null) {
            while (true) {
                if (n2 < this.timesig_positions.size()) {
                    midiEvent = this.timesig_positions.get(n2);
                    midiMessage = midiEvent.getMessage();
                    l3 = midiEvent.getTick();
                    l2 = l3;
                    if (l2 > l || midiMessage.getStatus() == 255 && ((MetaMessage)midiMessage).getType() == 47) {
                        l2 = l;
                    }
                } else {
                    l2 = l3 = l;
                }
                this.ticks_per_beat = this.ticks_per_whole_note >> this.timesig_lower_index;
                l5 = l2 - l4;
                int n3 = (int)(l5 / (long)this.ticks_per_beat);
                this.last_extra_tick = (int)(l5 % (long)this.ticks_per_beat);
                int n4 = n3 / this.timesig_upper;
                n = (byte)(n3 % this.timesig_upper);
                this.last_measure += n4;
                if (l3 > l) break;
                byArray = ((MetaMessage)midiMessage).getData();
                if (byArray.length > 0) {
                    this.timesig_upper = byArray[0];
                    this.timesig_lower_index = byArray[1];
                }
                if (l2 == l) break;
                if (n > 0) {
                    ++this.last_measure;
                }
                l4 = l2;
                ++n2;
            }
        }
        this.last_beat = n;
        return this.last_measure;
    }

    public long measureToTick(int n) {
        return this.measureToTick(n, 0, 0);
    }

    public long measureToTick(int n, int n2, int n3) {
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        byte[] byArray = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n4 = 0;
        this.timesig_upper = (byte)4;
        this.timesig_lower_index = (byte)2;
        while (true) {
            int n5 = this.ticks_per_whole_note >> this.timesig_lower_index;
            long l5 = (n * this.timesig_upper + n2) * n5 + n3;
            if (this.timesig_positions == null || n4 > this.timesig_positions.size()) {
                return l4 + l5;
            }
            midiEvent = this.timesig_positions.get(n4);
            midiMessage = midiEvent.getMessage();
            if (midiMessage.getStatus() == 255 && ((MetaMessage)midiMessage).getType() == 47) {
                return l4 + l5;
            }
            l = midiEvent.getTick();
            l3 = l - l2;
            if (l3 >= l5) {
                return l4 + l5;
            }
            n = (int)((long)n - l3 / (long)(n5 * this.timesig_upper));
            l4 += l3;
            byArray = ((MetaMessage)midiMessage).getData();
            this.timesig_upper = byArray[0];
            this.timesig_lower_index = byArray[1];
            l2 = l;
            ++n4;
        }
    }
}

