/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

class TempoSelecter
extends JPanel
implements MouseListener {
    JSpinner tempo_spinner;
    SpinnerNumberModel tempo_spinner_model;
    JLabel tempo_label;
    JLabel tempo_value_label;
    private boolean editable;
    static final int DEFAULT_QPM = 120;
    private long prev_beat_us_pos = 0L;

    public TempoSelecter() {
        String string = "Tempo in quatrers per minute - \u30c6\u30f3\u30dd\uff08\uff11\u5206\u3042\u305f\u308a\u306e\u56db\u5206\u97f3\u7b26\u306e\u6570\uff09";
        this.tempo_label = new JLabel("=", new ButtonIcon(138), 0);
        this.tempo_label.setVerticalAlignment(0);
        this.tempo_spinner_model = new SpinnerNumberModel(120, 1, 999, 1);
        this.tempo_spinner = new JSpinner(this.tempo_spinner_model);
        this.tempo_spinner.setToolTipText(string);
        this.tempo_value_label = new JLabel("120");
        this.tempo_value_label.setToolTipText(string);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.tempo_label);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.tempo_spinner);
        this.add(this.tempo_value_label);
        this.setEditable(true);
        this.tempo_label.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.tempo_label && this.isEditable()) {
            long l = System.nanoTime() / 1000L;
            long l2 = l - this.prev_beat_us_pos;
            this.prev_beat_us_pos = l;
            if (l2 < 2000000L) {
                int n = (int)(240000000L / l2) >> 2;
                int n2 = this.getTempoInQpm();
                this.setTempo((n + n2 * 2) / 3);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.tempo_spinner.setVisible(bl);
        this.tempo_value_label.setVisible(!bl);
        if (!bl) {
            this.tempo_value_label.setText("" + this.tempo_spinner_model.getNumber().intValue());
        }
        this.tempo_label.setToolTipText(bl ? "Click rhythmically to adjust tempo - \u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u30ea\u30ba\u30e0\u3092\u3068\u308b\u3068\u30c6\u30f3\u30dd\u3092\u5408\u308f\u305b\u3089\u308c\u307e\u3059" : null);
    }

    public int getTempoInQpm() {
        return this.tempo_spinner_model.getNumber().intValue();
    }

    public byte[] getTempoByteArray() {
        return MIDISpec.qpmTempoToByteArray(this.getTempoInQpm());
    }

    public void setTempo(int n) {
        this.tempo_spinner_model.setValue(new Integer(n));
        this.tempo_value_label.setText("" + n);
    }

    public void setTempo(byte[] byArray) {
        this.setTempo(MIDISpec.byteArrayToQpmTempo(byArray));
    }

    public void clear() {
        this.setTempo(120);
    }
}

