/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TickPositionModel
implements ChangeListener {
    private SequenceIndex seq_index;
    private boolean is_changing = false;
    public SpinnerNumberModel tick_model = new SpinnerNumberModel(0.0, 0.0, 999999.0, 1.0);
    public SpinnerNumberModel measure_model;
    public SpinnerNumberModel beat_model;
    public SpinnerNumberModel extra_tick_model;

    public TickPositionModel() {
        this.tick_model.addChangeListener(this);
        this.measure_model = new SpinnerNumberModel(1, 1, 9999, 1);
        this.measure_model.addChangeListener(this);
        this.beat_model = new SpinnerNumberModel(1, 1, 32, 1);
        this.beat_model.addChangeListener(this);
        this.extra_tick_model = new SpinnerNumberModel(0, 0, 3839, 1);
        this.extra_tick_model.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.seq_index == null) {
            return;
        }
        Object object = changeEvent.getSource();
        if (object == this.tick_model) {
            this.is_changing = true;
            this.measure_model.setValue(1 + this.seq_index.tickToMeasure(this.tick_model.getNumber().longValue()));
            this.beat_model.setValue(this.seq_index.last_beat + 1);
            this.is_changing = false;
            this.extra_tick_model.setValue(this.seq_index.last_extra_tick);
            return;
        }
        if (this.is_changing) {
            return;
        }
        this.tick_model.setValue(this.seq_index.measureToTick(this.measure_model.getNumber().intValue() - 1, this.beat_model.getNumber().intValue() - 1, this.extra_tick_model.getNumber().intValue()));
    }

    public SequenceIndex getSequenceIndex() {
        return this.seq_index;
    }

    public void setSequenceIndex(SequenceIndex sequenceIndex) {
        this.seq_index = sequenceIndex;
        this.extra_tick_model.setMaximum(Integer.valueOf(4 * sequenceIndex.getResolution() - 1));
    }

    public long getTickPosition() {
        return this.tick_model.getNumber().longValue();
    }

    public void setTickPosition(long l) {
        this.tick_model.setValue(l);
    }
}

