/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentValues;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.actionbarsherlock.app.SherlockFragment;
import info.projectkyoto.mms.assetmanager.common.MMSConfigBaseColumns;
import info.projectkyoto.mms.assetmanager.common.playerconfig.MMSPlayerConfig;
import info.projectkyoto.mms.assetmanager.common.playerconfig.ModelMotion;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author kobayasi
 */
public class ConfigEditorFragment extends SherlockFragment implements View.OnClickListener {

    private static final Logger logger = Logger.getLogger(ConfigEditorFragment.class.getName());
    Uri contentUri;
    Cursor cursor;
    String[] projection = {
        MMSConfigBaseColumns._ID,
        MMSConfigBaseColumns.CONFIG_TYPE,
        MMSConfigBaseColumns.CONFIG_NAME,
        MMSConfigBaseColumns.DESCRIPTION,
        MMSConfigBaseColumns.CONFIG_DATA};
    EditText configName;
    EditText description;
    TextView modelTextView;
    Button modelButton;
    TextView motionTextView;
    Button motionButton;
    TextView musicTextView;
    Button musicButton;
    Button okButton;
    MMSPlayerConfig config;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.config_detail, container, false);
        contentUri = getActivity().getIntent().getData();//(Uri)getArguments().get("uri");
        if (contentUri == null) {
            contentUri = MMSConfigBaseColumns.CONTENT_URI;
        }
        configName = (EditText) view.findViewById(R.id.configNameEditText);
        description = (EditText) view.findViewById(R.id.descriptionEditText);
        modelTextView = (TextView) view.findViewById(R.id.modelText);
        motionTextView = (TextView) view.findViewById(R.id.motionText);
        musicTextView = (TextView) view.findViewById(R.id.musicText);
        if (Intent.ACTION_INSERT.equals(getActivity().getIntent().getAction())) {
            Intent intent = getActivity().getIntent();
            if (intent.getExtras() != null) {
                String s = intent.getExtras().getString(MMSConfigBaseColumns.CONFIG_NAME);
                if (s != null) {
                    configName.setText(s);
                }
                s = intent.getExtras().getString(MMSConfigBaseColumns.DESCRIPTION);
                description.setText(s);
                String configData = intent.getExtras().getString(MMSConfigBaseColumns.CONFIG_DATA);
                if (configData != null) {
                    try {
                        config = new MMSPlayerConfig(new JSONObject(configData));
                    } catch (JSONException ex) {
                        Logger.getLogger(ConfigEditorFragment.class.getName()).log(Level.SEVERE, null, ex);
                        ArrayList<ModelMotion> list = new ArrayList<ModelMotion>();
                        list.add(new ModelMotion("", ""));
                        config = new MMSPlayerConfig("", list);
                    }
                }
                if (config == null) {
                    ArrayList<ModelMotion> list = new ArrayList<ModelMotion>();
                    list.add(new ModelMotion("", ""));
                    config = new MMSPlayerConfig("", list);
                }
                modelTextView.setText(config.getModelMotionList().get(0).getModelUri());
                motionTextView.setText(config.getModelMotionList().get(0).getMotionUri());
                musicTextView.setText(config.getMusicUri());
            }
            if (config == null) {
                ArrayList<ModelMotion> list = new ArrayList<ModelMotion>();
                list.add(new ModelMotion("", ""));
                config = new MMSPlayerConfig("", list);
            }
        } else if (Intent.ACTION_EDIT.equals(getActivity().getIntent().getAction())) {
            Intent intent = getActivity().getIntent();
            cursor = getActivity().getContentResolver().query(getActivity().getIntent().getData(), projection, null, null, null);
            try {
                if (cursor.moveToFirst()) {
                    configName.setText(cursor.getString(2));

                    description.setText(cursor.getString(3));

                    String configData = intent.getStringExtra(MMSConfigBaseColumns.CONFIG_DATA);
                    if (configData != null) {
                        config = new MMSPlayerConfig(new JSONObject(configData));
                    } else {
                        config = new MMSPlayerConfig(new JSONObject(cursor.getString(4)));
                    }
                    if (config == null) {
                        ArrayList<ModelMotion> list = new ArrayList<ModelMotion>();
                        list.add(new ModelMotion("", ""));
                        config = new MMSPlayerConfig("", list);
                    }
                    modelTextView.setText(config.getModelMotionList().get(0).getModelUri());
                    motionTextView.setText(config.getModelMotionList().get(0).getMotionUri());
                    musicTextView.setText(config.getMusicUri());
                }
            } catch (JSONException ex) {
                Logger.getLogger(ConfigEditorFragment.class.getName()).log(Level.SEVERE, null, ex);
                ArrayList<ModelMotion> list = new ArrayList<ModelMotion>();
                list.add(new ModelMotion("", ""));
                config = new MMSPlayerConfig("", list);
            } finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        } else {
            getActivity().finish();
        }
        modelButton = (Button) view.findViewById(R.id.modelButton);
        motionButton = (Button) view.findViewById(R.id.motionButton);
        musicButton = (Button) view.findViewById(R.id.musicButton);
        okButton = (Button) view.findViewById(R.id.okButton);
        okButton.setOnClickListener(this);
        modelButton.setOnClickListener(this);
        motionButton.setOnClickListener(this);
        musicButton.setOnClickListener(this);
        return view;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onClick(View v) {
        if (v == okButton) {
            try {
                config.setMusicUri(musicTextView.getText().toString());
                config.getModelMotionList().get(0).setModelUri(modelTextView.getText().toString());
                config.getModelMotionList().get(0).setMotionUri(motionTextView.getText().toString());
                ContentValues values = new ContentValues();
                values.put(MMSConfigBaseColumns.CONFIG_NAME, configName.getText().toString());
                values.put(MMSConfigBaseColumns.DESCRIPTION, description.getText().toString());
                JSONObject jo = config.toJSonObject();
                String json = jo.toString();
                values.put(MMSConfigBaseColumns.CONFIG_DATA, json);
                logger.info("json = " + json);
                if (Intent.ACTION_INSERT.equals(getActivity().getIntent().getAction())) {
                    values.put(MMSConfigBaseColumns.CONFIG_TYPE, MMSConfigBaseColumns.CONFIG_TYPE_PLAYER_1);
                    Uri data = getActivity().getContentResolver().insert(contentUri, values);
                    Intent intent = new Intent();
                    intent.setData(data);
                    getActivity().setResult(Activity.RESULT_OK, intent);
                    getActivity().finish();
                } else if (Intent.ACTION_EDIT.equals(getActivity().getIntent().getAction())) {
                    getActivity().getContentResolver().update(contentUri, values, null, null);
                    getActivity().finish();
                } else {
                    getActivity().finish();
                }
            } catch (SQLiteConstraintException ex) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                builder.setTitle("更新エラー");
                builder.setMessage("名前が既に使われています。");
                builder.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
                builder.create().show();
            } catch (JSONException ex) {
                Logger.getLogger(ConfigEditorFragment.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (v == modelButton) {
            Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
            intent.setType("application/x-mmd-pmd");
            startActivityForResult(intent, 4);
//                startActivityForResult(Intent.createChooser(intent, getResources().getString(R.string.open_pmd)),1);
        } else if (v == motionButton) {
            Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
            intent.setType("application/x-mmd-vmd");
            startActivityForResult(intent, 5);
//                startActivityForResult(Intent.createChooser(intent, getResources().getString(R.string.open_pmd)),1);
        } else if (v == musicButton) {
            Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
            intent.setType("audio/*");
            startActivityForResult(intent, 6);
//                startActivityForResult(Intent.createChooser(intent, getResources().getString(R.string.open_pmd)),1);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
//        super.onActivityResult(requestCode, resultCode, data);
        logger.info("onActivityResult: resultCode = " + resultCode + " requestCode = " + requestCode + " data = " + data);
        if (resultCode == Activity.RESULT_OK && requestCode == 4 && data != null) {
            Uri uri = data.getData();
            this.modelTextView.setText(uri.toString());
        } else if (resultCode == Activity.RESULT_OK && requestCode == 5 && data != null) {
            Uri uri = data.getData();
            this.motionTextView.setText(uri.toString());
        } else if (resultCode == Activity.RESULT_OK && requestCode == 6 && data != null) {
            Uri uri = data.getData();
            this.musicTextView.setText(uri.toString());
        }
    }
}