/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Contacts.People;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SearchViewCompat;
import android.support.v4.widget.SimpleCursorAdapter;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.View;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.ListView;
import com.actionbarsherlock.app.SherlockListFragment;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import info.projectkyoto.mms.assetmanager.common.MMSConfigBaseColumns;
import java.util.Map;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class ConfigListFragment extends SherlockListFragment
        implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final Logger logger = Logger.getLogger(ConfigListFragment.class.getName());
    // This is the Adapter being used to display the list's data.
    SimpleCursorAdapter mAdapter;
    // If non-null, this is the current filter the user has provided.
    String mCurFilter;

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        logger.info("onActivityCreated");
        super.onActivityCreated(savedInstanceState);

        // Give some text to display if there is no data.  In a real
        // application this would come from a resource.
        setEmptyText("No phone numbers");

        // We have a menu item to show in action bar.
        setHasOptionsMenu(true);

        // Create an empty adapter we will use to display the loaded data.
        mAdapter = new SimpleCursorAdapter(getActivity(),
                R.layout.config_row, null,
                new String[]{MMSConfigBaseColumns.CONFIG_NAME, MMSConfigBaseColumns.DESCRIPTION},
                new int[]{R.id.configName, R.id.description}, 0);
        setListAdapter(mAdapter);

        // Start out with a progress indicator.
        setListShown(false);

        // Prepare the loader.  Either re-connect with an existing one,
        // or start a new one.
        getLoaderManager().initLoader(0, null, this);
        registerForContextMenu(getListView());
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        // Place an action bar item for searching.
        MenuItem item = menu.add("Search");
        item.setIcon(android.R.drawable.ic_menu_search);
        item.setShowAsAction(MenuItem.SHOW_AS_ACTION_ALWAYS);
        View searchView = SearchViewCompat.newSearchView(getActivity());
        if (searchView != null) {
            SearchViewCompat.setOnQueryTextListener(searchView,
                    new SearchViewCompat.OnQueryTextListenerCompat() {

                        @Override
                        public boolean onQueryTextChange(String newText) {
                            // Called when the action bar search text has changed.  Update
                            // the search filter, and restart the loader to do a new query
                            // with this filter.
                            mCurFilter = !TextUtils.isEmpty(newText) ? newText : null;
                            getLoaderManager().restartLoader(0, null, ConfigListFragment.this);
                            return true;
                        }
                    });
            item.setActionView(searchView);
        }
        Intent intent = new Intent();
        intent.setAction(Intent.ACTION_INSERT);
        intent.setType(MMSConfigBaseColumns.CONTENT_TYPE);
        menu.add("add")
                .setIcon(android.R.drawable.ic_menu_add)
                .setIntent(intent)
                .setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM);
                
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
//        if (!AssetManagerUtil.checkSDCard(getActivity(), false)) {
//            return true;
//        }
//        switch (item.getItemId()) {
//            case R.id.install_zip:
//                Intent intent = new Intent();
//                intent.setAction(Intent.ACTION_INSERT);
//                intent.setType(MMSConfigBaseColumns.CONTENT_TYPE);
//                startActivity(intent);
//                return true;
//        }
        return super.onOptionsItemSelected(item);
    }
    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add(0, R.string.delete_asset, 0, R.string.delete_asset);
    }
    @Override
    public boolean onContextItemSelected(android.view.MenuItem item) {
        AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
        int pos = info.position;
        long id = mAdapter.getItemId(pos);
        Uri uri = ContentUris.withAppendedId(getActivity().getIntent().getData(), id);
        switch (item.getItemId()) {
            case R.string.delete_asset:
                getActivity().getContentResolver().delete(uri, null, null);
                return true;
        }
        return super.onContextItemSelected(item);
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        // Insert desired behavior here.
        Log.i("FragmentComplexList", "Item clicked: " + id);
        Intent intent = getActivity().getIntent();
        Uri uri = ContentUris.withAppendedId(intent.getData(), id);
        Log.i("FragmentComplexList","uri = "+uri.toString());
        if (Intent.ACTION_PICK.equals(intent.getAction())) {
            getActivity().setResult(Activity.RESULT_OK, new Intent().setData(uri));
            getActivity().finish();
        } else if (Intent.ACTION_GET_CONTENT.equals(intent.getAction())) {
            getActivity().setResult(Activity.RESULT_OK, new Intent().setData(uri));
            getActivity().finish();
        } else {
            Intent intent2 = new Intent();
            intent2.setAction(Intent.ACTION_EDIT);
            intent2.setData(uri);
            startActivity(intent2);
        }
    }
    // These are the Contacts rows that we will retrieve.
    static final String[] CONTACTS_SUMMARY_PROJECTION = new String[]{
        MMSConfigBaseColumns._ID,
        MMSConfigBaseColumns.CONFIG_NAME,
        MMSConfigBaseColumns.DESCRIPTION
    };

    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        // This is called when a new Loader needs to be created.  This
        // sample only has one Loader, so we don't care about the ID.
        // First, pick the base URI to use depending on whether we are
        // currently filtering.
        logger.info("onCreateLoader");
        Uri baseUri;
        if (mCurFilter != null) {
//            baseUri = Uri.withAppendedPath(People.CONTENT_FILTER_URI, Uri.encode(mCurFilter));
            baseUri = getActivity().getIntent().getData();
        } else {
            baseUri = getActivity().getIntent().getData();
        }

        // Now create and return a CursorLoader that will take care of
        // creating a Cursor for the data being displayed.
        String select = "";
        return new CursorLoader(getActivity(), baseUri,
                CONTACTS_SUMMARY_PROJECTION, select, null,
                MMSConfigBaseColumns.CONFIG_NAME + " COLLATE LOCALIZED ASC");
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        // Swap the new cursor in.  (The framework will take care of closing the
        // old cursor once we return.)
        logger.info("onLoadFinished");
        mAdapter.swapCursor(data);

        // The list should now be shown.
        if (isResumed()) {
            setListShown(true);
        } else {
            setListShownNoAnimation(true);
        }
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        logger.info("onLoaderReset");
        // This is called when the last Cursor provided to onLoadFinished()
        // above is about to be closed.  We need to make sure we are no
        // longer using it.
        mAdapter.swapCursor(null);
    }

    @Override
    public void onResume() {
        super.onResume();
//        getLoaderManager().restartLoader(0, null, this);
    }
    
}
