/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.ListFragment;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import com.actionbarsherlock.app.SherlockListFragment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/**
 *
 * @author kobayasi
 */
public class ContentListFragment extends SherlockListFragment {

    private static final Logger logger = Logger.getLogger(ContentListFragment.class.getName());
    File contentDir;
    File dir;
    String ext;
    boolean viewOnly;
    ArrayList<String> list = new ArrayList<String>();
    ArrayList<File> fileList = new ArrayList<File>();

    public ContentListFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.content_list, container, false);
        this.dir = new File(getArguments().getString("file"));
        this.ext = getArguments().getString("ext");
        this.viewOnly = getArguments().getBoolean("viewOnly");
        refresh(dir);
        contentDir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/local");
        return view;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ArrayAdapter aa = new ArrayAdapter(getActivity(), android.R.layout.simple_list_item_1, list);
        setListAdapter(aa);
        TextView textView1 = (TextView) getView().findViewById(R.id.textView1);
        if (viewOnly) {
//            textView1.setVisibility(View.GONE);
        }
        getListView().setItemsCanFocus(true);
    }

    private void refresh(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                refresh(file2);
            } else {
                if (file2.getName().toLowerCase().endsWith(ext)) {
                    list.add(file2.getName());
                    fileList.add(file2);
                }
            }
        }
    }

//    @Override
    public void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        if (!viewOnly) {
            try {

                File file = fileList.get(position);
                String s1 = contentDir.getCanonicalPath();
                String s2 = file.getCanonicalPath();
                String s3 = s2.substring(s1.length());
                Uri uri = Uri.parse(AssetManager.CONTENT_URI_CONTENT.toString() + s3);
                logger.info("uri = " + uri.toString());
                Intent intent = new Intent();
                intent.setData(uri);
                getActivity().setResult(Activity.RESULT_OK, intent);
                getActivity().finish();
            } catch (IOException ex) {
                Logger.getLogger(ContentListFragment.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}
