/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipFile;

/**
 *
 * @author kobayasi
 */
public class DeleteDirectoryAsyncTask extends AsyncTask<String, Object, Long> {

    private static final Logger logger = Logger.getLogger(DeleteDirectoryAsyncTask.class.getName());
    ProgressDialog pd;
    Context context;
    File dir;
    File contentDir;
    ZipFile zipFile;
    FileSelectFragment fsf;

    public DeleteDirectoryAsyncTask(Context context, File dir, FileSelectFragment fsf) {
        super();
        this.context = context;
        this.dir = dir;
        this.fsf = fsf;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        pd = new ProgressDialog(context);
        pd.setTitle(context.getString(R.string.wait_message));
        pd.setMessage("Loading data....");
        pd.setCancelable(true);
        pd.setMax(100);
        pd.setProgress(0);
//        pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        pd.setIndeterminate(false);
        pd.show();
    }

    @Override
    protected Long doInBackground(String... params) {
        byte[] buf = new byte[1024 * 16];
        File archiveDir = null;
        boolean done = false;
        try {
            deleteDir(dir);
            done = true;
            return null;
        } catch (Exception ex) {
            Logger.getLogger(InstallZipAsyncTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    protected void onProgressUpdate(Object... values) {
        super.onProgressUpdate(values);
        pd.setProgress((Integer) values[0]);
        pd.setMessage((String) values[1]);
    }

    @Override
    protected void onPostExecute(Long result) {
        super.onPostExecute(result);
        fsf.refresh();
        pd.dismiss();
    }

    private void deleteDir(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                deleteDir(child);
            }
        }
        file.delete();
    }
}
