/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

/**
 *
 * @author kobayasi
 */
public class InstallZipAsyncTask extends AsyncTask<String, Object, Long> {

    private static final Logger logger = Logger.getLogger(InstallZipAsyncTask.class.getName());
    ProgressDialog pd;
    Context context;
    Uri uri;
    File contentDir;
    ZipFile zipFile;

    public InstallZipAsyncTask(Context context, Uri uri) {
        super();
        this.context = context;
        this.uri = uri;
        contentDir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/local");
        contentDir.mkdirs();
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        pd = new ProgressDialog(context);
        pd.setTitle(context.getString(R.string.wait_message));
        pd.setMessage("Loading data....");
        pd.setCancelable(true);
        pd.setMax(100);
        pd.setProgress(0);
        pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        pd.setIndeterminate(false);
        pd.show();
    }

    @Override
    protected Long doInBackground(String... params) {
        byte[] buf = new byte[1024 * 16];
        OutputStream os = null;
        InputStream is = null;
        File archiveDir = null;
        boolean done = false;
        try {
            File nomedia = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms/.nomedia");
            nomedia.createNewFile();
            publishProgress(10, context.getString(R.string.open_archive_message, uri));
            openZipFile();
            publishProgress(20, context.getString(R.string.extract_archive_message, uri));
            archiveDir = new File(contentDir, uri.getLastPathSegment());
            if (archiveDir.exists()) {
                deleteDir(archiveDir);
            }
            archiveDir.mkdirs();
            Enumeration<ZipArchiveEntry> e = zipFile.getEntries();
            int entryCount = 0;
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = e.nextElement();
                if (!entry.isDirectory()) {
                    entryCount++;
                }
            }
            e = zipFile.getEntries();
            int count = 0;
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = e.nextElement();
                if (!entry.isDirectory()) {
                    Integer progress = new Integer(30 + 70 * count / entryCount);
                    publishProgress(progress, context.getString(R.string.extract_file_message, entry.getName()));
                    File contentFile = new File(archiveDir, entry.getName());
                    if (!contentFile.getCanonicalPath().startsWith(archiveDir.getCanonicalPath())) {
                        throw new IOException("Invalid entry name:" + entry.getName());
                    }
                    contentFile.getParentFile().mkdirs();
                    os = new FileOutputStream(contentFile);
                    is = zipFile.getInputStream(entry);
                    for (;;) {
                        int length = is.read(buf);
                        if (length < 0) {
                            break;
                        }
                        os.write(buf, 0, length);
                        if (isCancelled()) {
                            return null;
                        }
                    }
                    is.close();
                    is = null;
                    os.close();
                    os = null;
                    count++;
                }
            }
            publishProgress(100, "Done.");
            done = true;
            return null;
        } catch (Exception ex) {
            Logger.getLogger(InstallZipAsyncTask.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException ex) {
                    Logger.getLogger(InstallZipAsyncTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!done && archiveDir != null) {
                deleteDir(archiveDir);
            }
        }
        return null;
    }

    @Override
    protected void onProgressUpdate(Object... values) {
        super.onProgressUpdate(values);
        pd.setProgress((Integer) values[0]);
        pd.setMessage((String) values[1]);
    }

    @Override
    protected void onPostExecute(Long result) {
        super.onPostExecute(result);
        pd.dismiss();
    }

    private void openZipFile() throws IOException {
        if (uri.getScheme().equals("file")) {
            File file = new File(uri.getPath());
            zipFile = new ZipFile(file, "MS932");
        }
    }

    private void deleteDir(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                deleteDir(child);
            }
        }
        file.delete();
    }
}
