/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.app.Application;
import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class MMSApplication extends Application {
    private static final Logger logger = Logger.getLogger(MMSApplication.class.getName());
    private File dataDir;
    private File configDBFile;
    @Override
    public void onCreate() {
        super.onCreate();
    }
    private void initDirs() {
        try {
            dataDir = new File(Environment.getExternalStorageDirectory(), "info.projectkyoto.mms");
            dataDir.mkdirs();
            File nomedia = new File(dataDir, ".nomedia");
            nomedia.createNewFile();
            File dbDir = new File(dataDir, "database");
            dbDir.mkdirs();
            configDBFile = new File(dbDir, "config.db");
        } catch (IOException ex) {
            Logger.getLogger(MMSApplication.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
    public File getDataDir() {
        initDirs();
        return dataDir;
    }
    public File getConfigDBFile() {
        initDirs();
        return configDBFile;
    }
}
