/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.widget.Toast;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

/**
 *
 * @author kobayasi
 */
public class MMSContentProviderOld extends ContentProvider {

    Logger logger = Logger.getLogger(MMSContentProviderOld.class.getName());
    public static final int ARCHIVES = 1;
    public static final int ARCHIVE_ID = 2;
    public static final int ZIPENTRIES = 3;
    public static final int ZIPENTRY_ID = 4;
    private static final UriMatcher sUriMatcher;
    private static final HashMap<String, String> sArchiveProjectionMap;
    private static final HashMap<String, String> sZipEntryProjectionMap;
    private AssetDB assetDB;

    @Override
    public boolean onCreate() {
        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            logger.severe("sdcard is not mounted.");
            return false;
        }
        assetDB = new AssetDB(getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs,
            String sortOrder) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables("archive");

        switch (sUriMatcher.match(uri)) {
            case ARCHIVES:
                qb.setProjectionMap(sArchiveProjectionMap);
                break;

            case ARCHIVE_ID:
                qb.setProjectionMap(sArchiveProjectionMap);
                qb.appendWhere("_id" + "=" + uri.getPathSegments().get(1));
                break;
            case ZIPENTRIES:
                qb.setProjectionMap(sZipEntryProjectionMap);
                break;

            case ZIPENTRY_ID:
                qb.setProjectionMap(sZipEntryProjectionMap);
                qb.appendWhere("_id" + "=" + uri.getPathSegments().get(1));
                break;

            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }

        // If no sort order is specified use the default
        String orderBy;
        if (TextUtils.isEmpty(sortOrder)) {
            orderBy = "_id DESC";
        } else {
            orderBy = sortOrder;
        }

        // Get the database and run the query
        SQLiteDatabase db = assetDB.getReadableDatabase();
        Cursor c = qb.query(db, projection, selection, selectionArgs, null, null, orderBy);

        // Tell the cursor what uri to watch, so it knows when its source data changes
        c.setNotificationUri(getContext().getContentResolver(), uri);
        return c;
    }

    @Override
    public String getType(Uri uri) {
        switch (sUriMatcher.match(uri)) {
            case ARCHIVES:
                return AssetManager.CONTENT_TYPE_ARCHIVE;

            case ARCHIVE_ID:
                return AssetManager.CONTENT_ITEM_TYPE_ARCHIVE;
            case ZIPENTRIES:
                return AssetManager.CONTENT_TYPE_ZIP_ENTRY;

            case ZIPENTRY_ID:
                return AssetManager.CONTENT_ITEM_TYPE_ZIP_ENTRY;
            default:
                return null;
        }
    }

    @Override
    public Uri insert(Uri uri, ContentValues initialValues) {
        // Validate the requested uri
        if (sUriMatcher.match(uri) != ARCHIVES) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }

        ContentValues values;
        if (initialValues != null) {
            values = new ContentValues(initialValues);
        } else {
            values = new ContentValues();
        }

        String fileName = initialValues.getAsString("fileName");

//        SQLiteDatabase db = assetDB.getWritableDatabase();
//        long rowId = db.insert("archive", null, values);
        long rowId = assetDB.addZipFile(Uri.parse(fileName));
        if (rowId > 0) {
            Uri archiveUri = ContentUris.withAppendedId(AssetManager.CONTENT_URI_ARCHIVE, rowId);
            getContext().getContentResolver().notifyChange(archiveUri, null);
            return archiveUri;
        }
        throw new SQLException("Failed to insert row into " + uri);
    }

    @Override
    public int delete(Uri uri, String where, String[] whereArgs) {
        SQLiteDatabase db = assetDB.getWritableDatabase();
        int count;
        switch (sUriMatcher.match(uri)) {
//            case ARCHIVES:
//                count = db.delete("archive", where, whereArgs);
//                break;

            case ARCHIVE_ID:
                String archiveId = uri.getPathSegments().get(1);
//                count = db.delete("archive", "_id" + "=" + archiveId
//                        + (!TextUtils.isEmpty(where) ? " AND (" + where + ')' : ""), whereArgs);
                count = assetDB.deleteArchive(Long.parseLong(archiveId));
                break;

            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }

        getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    @Override
    public int update(Uri uri, ContentValues values, String where, String[] whereArgs) {
        SQLiteDatabase db = assetDB.getWritableDatabase();
        int count;
        switch (sUriMatcher.match(uri)) {
            case ARCHIVES:
                count = db.update("archive", values, where, whereArgs);
                break;

            case ARCHIVE_ID:
                String noteId = uri.getPathSegments().get(1);
                count = db.update("archive", values, "_id" + "=" + noteId
                        + (!TextUtils.isEmpty(where) ? " AND (" + where + ')' : ""), whereArgs);
                break;

            default:
                throw new IllegalArgumentException("Unknown URI " + uri);
        }

        getContext().getContentResolver().notifyChange(uri, null);
        return count;
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        checkCondition();
        List<String> pathSegments = uri.getPathSegments();
        Cursor c = null;
        try {
            if (pathSegments.size() < 3) {
                throw new IllegalArgumentException("Unknown URI " + uri);
            } else if (pathSegments.get(0).equals("contents")) {
                String archiveName = URLDecoder.decode(pathSegments.get(1));
                int len = 1 + pathSegments.get(0).length() + pathSegments.get(0).length() + 1;
                String entryName = uri.getPath().substring(len);
                //            logger.info("uri = "+uri.toString()+" "+"archiveName = "+archiveName+" entryName = "+entryName);
                SQLiteDatabase db = assetDB.getReadableDatabase();
                c = db.rawQuery("SELECT _id FROM archive WHERE fileName = ?", new String[]{archiveName});
                if (c.moveToFirst()) {
                    long archiveId = c.getLong(0);
                    c.close();
                    c = null;
                    c = db.rawQuery("SELECT _id FROM zipEntry WHERE archiveId = ? AND entryName = ?"
                            , new String[]{Long.toString(archiveId), entryName});
                    if (c.moveToFirst()) {
                        long zipEntryId = c.getLong(0);
                        c.close();
                        c = null;
                        File entryFile = new File(assetDB.contentDir, Long.toHexString(zipEntryId));
                        ParcelFileDescriptor pfd = FileUtil.openFile(new File(archiveName));
                        return pfd;
                    }
                }
            }
        } finally {
            if (c != null) {
                c.close();
            }
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    private void checkCondition() {
        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            throw new IllegalStateException("sdcard is not mounted.");
        }
        if (assetDB == null || !assetDB.checkCondition()) {
            assetDB = new AssetDB(getContext());
        }
    }
    static {
        sUriMatcher = new UriMatcher(UriMatcher.NO_MATCH);
        sUriMatcher.addURI(AssetManager.AUTHORITY, "archives", ARCHIVES);
        sUriMatcher.addURI(AssetManager.AUTHORITY, "archives/#", ARCHIVE_ID);
        sUriMatcher.addURI(AssetManager.AUTHORITY, "zipentries", ZIPENTRIES);
        sUriMatcher.addURI(AssetManager.AUTHORITY, "zipentries/#", ZIPENTRY_ID);
        sArchiveProjectionMap = new HashMap<String, String>();
        sArchiveProjectionMap.put("_id", "_id");
        sArchiveProjectionMap.put("fileName", "fileName");
        sArchiveProjectionMap.put("size", "size");
        sZipEntryProjectionMap = new HashMap<String, String>();
        sZipEntryProjectionMap.put("_id","_id");
        sZipEntryProjectionMap.put("archiveId","archiveId");
        sZipEntryProjectionMap.put("entryName","entryName");
        sZipEntryProjectionMap.put("size","size");
        
    }
}
