/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types.apply;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.Convert;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;

public class ApplyRenderText
implements ApplyRenderer {
    private final Convert convert;

    public ApplyRenderText(Convert convertParam) {
        this.convert = convertParam;
    }

    @Override
    public void apply(Screen screen, Element element, Attributes attributes, NiftyRenderEngine renderEngine) {
        TextRenderer textRenderer = element.getRenderer(TextRenderer.class);
        if (textRenderer == null) {
            return;
        }
        textRenderer.setFont(this.convert.font(renderEngine, attributes.get("font")));
        textRenderer.setTextHAlign(this.convert.textHorizontalAlign(attributes.get("textHAlign")));
        textRenderer.setTextVAlign(this.convert.textVerticalAlign(attributes.get("textVAlign")));
        textRenderer.setColor(this.convert.color(attributes.get("color")));
        textRenderer.setTextSelectionColor(this.convert.color(attributes.get("selectionColor")));
        textRenderer.setText(attributes.get("text"));
        textRenderer.setTextLineHeight(this.convert.sizeValue(attributes.get("textLineHeight")));
        textRenderer.setTextMinHeight(this.convert.sizeValue(attributes.get("textMinHeight")));
        boolean wrap = attributes.getAsBoolean("wrap", false);
        textRenderer.setLineWrapping(wrap);
        if (!wrap) {
            if (element.getConstraintWidth() == null) {
                element.setConstraintWidth(this.convert.sizeValue(textRenderer.getTextWidth() + "px"));
            }
            if (element.getConstraintHeight() == null) {
                element.setConstraintHeight(this.convert.sizeValue(textRenderer.getTextHeight() + "px"));
            }
        }
    }
}

