/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.batch.BatchRenderDevice;
import de.lessvoid.nifty.render.NiftyImageManagerExt;
import de.lessvoid.nifty.render.NiftyImageManagerExtBatch;
import de.lessvoid.nifty.render.NiftyImageManagerExtStandard;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NiftyImageManager {
    private static Logger log = Logger.getLogger(NiftyImageManager.class.getName());
    private final RenderDevice renderDevice;
    private Map<String, ReferencedCountedImage> imageCache = new HashMap<String, ReferencedCountedImage>();
    private Map<RenderImage, ReferencedCountedImage> backReference = new HashMap<RenderImage, ReferencedCountedImage>();
    private final NiftyImageManagerExt<ReferencedCountedImage> ext;

    public NiftyImageManager(RenderDevice renderDevice) {
        this.renderDevice = renderDevice;
        this.ext = this.getExtImpl(renderDevice);
    }

    public RenderImage registerImage(String filename, boolean filterLinear, Screen screen) {
        ReferencedCountedImage image = this.addImage(filename, filterLinear, screen);
        this.ext.registerImage(screen, image);
        return image.getRenderImage();
    }

    public void unregisterImage(RenderImage image) {
        ReferencedCountedImage reference;
        if (this.backReference.containsKey(image) && this.removeImage(reference = this.backReference.get(image))) {
            this.ext.unregisterImage(reference);
        }
    }

    public void uploadScreenImages(Screen screen) {
        log.fine(">>> uploadScreenImages [" + screen.getScreenId() + "] start");
        NiftyStopwatch.start();
        this.ext.uploadScreenImages(screen);
        long time = NiftyStopwatch.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("{" + String.format("%d", time) + " ms} <<< uploadScreenImages [" + screen.getScreenId() + "]");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("{" + String.format("%d", time) + " ms} <<< uploadScreenImages [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void unloadScreenImages(Screen screen) {
        log.fine(">>> unloadScreenImages [" + screen.getScreenId() + "] start");
        NiftyStopwatch.start();
        this.ext.unloadScreenImages(screen, this.renderDevice, this.imageCache.values());
        long time = NiftyStopwatch.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("{" + String.format("%d", time) + " ms} <<< unloadScreenImages [" + screen.getScreenId() + "]");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("{" + String.format("%d", time) + " ms} <<< unloadScreenImages [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void screenAdded(Screen screen) {
        this.ext.screenAdded(screen);
        if (log.isLoggable(Level.FINER)) {
            log.finer("screenAdded [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public void screenRemoved(Screen screen) {
        this.ext.screenRemoved(screen);
        if (log.isLoggable(Level.FINER)) {
            log.finer("screenRemoved [" + screen.getScreenId() + "] " + this.getInfoString());
        }
    }

    public RenderImage reload(RenderImage image) {
        if (this.backReference.containsKey(image)) {
            return this.backReference.get(image).reload();
        }
        return image;
    }

    public String getInfoString() {
        StringBuffer result = new StringBuffer();
        result.append(this.imageCache.size() + " entries in cache and " + this.backReference.size() + " backreference entries.");
        this.ext.addScreenInfo(result);
        return result.toString();
    }

    private NiftyImageManagerExt<ReferencedCountedImage> getExtImpl(RenderDevice renderer) {
        if (renderer instanceof BatchRenderDevice) {
            NiftyImageManagerExtBatch<ReferencedCountedImage> b = new NiftyImageManagerExtBatch<ReferencedCountedImage>();
            return b;
        }
        return new NiftyImageManagerExtStandard<ReferencedCountedImage>();
    }

    private static String buildName(String filename, boolean filterLinear) {
        return filename + "|" + filterLinear;
    }

    private ReferencedCountedImage addImage(String filename, boolean filterLinear, Screen screen) {
        String key = NiftyImageManager.buildName(filename, filterLinear);
        if (this.imageCache.containsKey(key)) {
            ReferencedCountedImage existingImage = this.imageCache.get(key);
            existingImage.addReference();
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + screen.getScreenId() + "][" + key + "] refcount++ [" + existingImage.getReferences() + "]");
            }
            return existingImage;
        }
        NiftyStopwatch.start();
        RenderImage renderImage = this.renderDevice.createImage(filename, filterLinear);
        ReferencedCountedImage newImage = this.ext.createReferencedCountedImage(this.renderDevice, screen, filename, filterLinear, renderImage, key);
        this.backReference.put(renderImage, newImage);
        this.imageCache.put(key, newImage);
        NiftyStopwatch.stop("imageManager.getImage(" + filename + ")");
        return newImage;
    }

    private boolean removeImage(ReferencedCountedImage reference) {
        Screen screen = reference.getScreen();
        if (reference.removeReference()) {
            this.imageCache.remove(reference.getName());
            this.backReference.remove(reference.getRenderImage());
            if (log.isLoggable(Level.FINER)) {
                log.finer("[" + (screen == null ? "---" : screen.getScreenId()) + "][" + reference.getName() + "] refcount-- [" + reference.getReferences() + "] => DISPOSED");
            }
            return true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("[" + (screen == null ? "---" : screen.getScreenId()) + "][" + reference.getName() + "] refcount-- [" + reference.getReferences() + "]");
        }
        return false;
    }

    public static interface ReferencedCountedImage {
        public RenderImage reload();

        public RenderImage addReference();

        public boolean removeReference();

        public int getReferences();

        public RenderImage getRenderImage();

        public String getName();

        public Screen getScreen();
    }
}

