/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control.ragdoll;

import com.jme3.bullet.joints.SixDofJoint;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RagdollPreset {
    protected static final Logger logger = Logger.getLogger(RagdollPreset.class.getName());
    protected Map<String, JointPreset> boneMap = new HashMap<String, JointPreset>();
    protected Map<String, LexiconEntry> lexicon = new HashMap<String, LexiconEntry>();

    protected abstract void initBoneMap();

    protected abstract void initLexicon();

    public void setupJointForBone(String string, SixDofJoint sixDofJoint) {
        if (this.boneMap.isEmpty()) {
            this.initBoneMap();
        }
        if (this.lexicon.isEmpty()) {
            this.initLexicon();
        }
        String string2 = "";
        int n = 0;
        for (String string3 : this.lexicon.keySet()) {
            int n2 = this.lexicon.get(string3).getScore(string);
            if (n2 <= n) continue;
            n = n2;
            string2 = string3;
        }
        JointPreset jointPreset = this.boneMap.get(string2);
        if (jointPreset != null && n >= 50) {
            logger.log(Level.INFO, "Found matching joint for bone {0} : {1} with score {2}", new Object[]{string, string2, n});
            jointPreset.setupJoint(sixDofJoint);
        } else {
            logger.log(Level.INFO, "No joint match found for bone {0}", string);
            if (n > 0) {
                logger.log(Level.INFO, "Best match found is {0} with score {1}", new Object[]{string2, n});
            }
            new JointPreset().setupJoint(sixDofJoint);
        }
    }

    protected class LexiconEntry
    extends HashMap<String, Integer> {
        protected LexiconEntry() {
        }

        public void addSynonym(String string, int n) {
            this.put(string.toLowerCase(), n);
        }

        public int getScore(String string) {
            int n = 0;
            String string2 = string.toLowerCase();
            for (String string3 : this.keySet()) {
                if (string2.indexOf(string3) < 0) continue;
                n += ((Integer)this.get(string3)).intValue();
            }
            return n;
        }
    }

    protected class JointPreset {
        private float maxX;
        private float minX;
        private float maxY;
        private float minY;
        private float maxZ;
        private float minZ;

        public JointPreset() {
        }

        public JointPreset(float f, float f2, float f3, float f4, float f5, float f6) {
            this.maxX = f;
            this.minX = f2;
            this.maxY = f3;
            this.minY = f4;
            this.maxZ = f5;
            this.minZ = f6;
        }

        public void setupJoint(SixDofJoint sixDofJoint) {
            sixDofJoint.getRotationalLimitMotor(0).setHiLimit(this.maxX);
            sixDofJoint.getRotationalLimitMotor(0).setLoLimit(this.minX);
            sixDofJoint.getRotationalLimitMotor(1).setHiLimit(this.maxY);
            sixDofJoint.getRotationalLimitMotor(1).setLoLimit(this.minY);
            sixDofJoint.getRotationalLimitMotor(2).setHiLimit(this.maxZ);
            sixDofJoint.getRotationalLimitMotor(2).setLoLimit(this.minZ);
        }
    }
}

